% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-add_service.R
\name{add_plumber_service}
\alias{add_plumber_service}
\alias{add_service}
\title{Add a Service Route to the Microservice}
\usage{
add_plumber_service(path = ".", name, overwrite = FALSE)

add_service(path = ".", name, overwrite = FALSE)
}
\arguments{
\item{path}{(\code{character}) Where is the project root folder?}

\item{name}{(\code{character}) what is the service route name? For example, if
\code{name} = "repository" then the set of services would become available
at \verb{http://127.0.0.1:8080/repository/}.}

\item{overwrite}{(\code{logical}) Should existing destination files be overwritten?}
}
\value{
No return value, called for side effects.
}
\description{
Expose additional set of services on a separate URL.
}
\note{
\code{add_plumber_service()} and \code{add_service()} are synonyms.
}
\examples{
path <- tempfile()
dir.create(path, showWarnings = FALSE, recursive = TRUE)
use_plumber_microservice(path)

add_plumber_service(path, name = "repository")

list.files(path, recursive = TRUE)
}
\seealso{
Other plumber microservice: 
\code{\link{use_plumber_microservice}()}
}
\concept{plumber microservice}
