% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tobit1.R
\name{tobit1}
\alias{tobit1}
\title{Truncated response model}
\usage{
tobit1(
  formula,
  data,
  subset = NULL,
  weights = NULL,
  start = NULL,
  left = 0,
  right = Inf,
  scedas = NULL,
  sample = c("censored", "truncated"),
  method = c("ml", "lm", "twosteps", "trimmed", "nls", "minchisq", "test"),
  trace = FALSE,
  ...
)
}
\arguments{
\item{formula}{a symbolic description of the model; if two right
hand sides are provided, the second one described the set of
instruments if \code{scedas} is \code{NULL}, which is the
default. Otherwise, the second part indicates the set of
covariates for the variance function}

\item{data, subset, weights}{see \code{lm}}

\item{start}{an optional vector of starting values}

\item{left, right}{left and right truncation points for the response
The default is respectively 0 and +Inf which corresponds to the
most classic (left-zero truncated) tobit model}

\item{scedas}{the functional form used to specify the conditional
variance, either \code{"exp"} or \code{"pnorm"}}

\item{sample}{either \code{"censored"} (the default) to estimate the
censored (tobit) regression model or \code{"truncated"} to estimated
the truncated regression model}

\item{method}{one of \code{"ml"} for maximum likelihood, \code{"lm"} for
(biased) least squares estimators, \code{"twosteps"} for two-steps
consistent estimators, \code{"trimmed"} for symetrically censored
estimator, \code{"minchisq"} and \code{"test"}. The last two are only
relevant for instrumental variable estimation (when the formula
is a two-parts formula and \code{scedas} is \code{NULL})}

\item{trace}{a boolean (the default if \code{FALSE}) if \code{TRUE} some
information about the optimization process is printed}

\item{...}{further arguments}
}
\value{
An object of class \code{c("tobit1", "micsr")}, see
\code{micsr::micsr} for further details.
}
\description{
Estimation of models for which the response is truncated, either on
censored or truncated samples using OLS, NLS, maximum
likelihood, two-steps estimators or trimmed estimators
}
\examples{
charitable$logdon <- with(charitable, log(donation) - log(25))
ml <- tobit1(logdon ~ log(donparents) + log(income) + education +
             religion + married + south, data = charitable)
scls <- update(ml, method = "trimmed")
tr <- update(ml, sample = "truncated")
nls <- update(tr, method = "nls")
}
\references{
\insertRef{POWE:86}{micsr}
}
\author{
Yves Croissant
}
\keyword{models}
