% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndvuong.R
\name{ndvuong}
\alias{ndvuong}
\title{Non-degenerate Vuong test}
\usage{
ndvuong(
  x,
  y,
  size = 0.05,
  pval = TRUE,
  nested = FALSE,
  vartest = FALSE,
  ndraws = 10000,
  diffnorm = 0.1,
  seed = 1,
  numbers = NULL,
  nd = TRUE,
  print.level = 0
)
}
\arguments{
\item{x}{a first fitted model}

\item{y}{a second fitted model}

\item{size}{the size of the test}

\item{pval}{should the p-value be computed ?}

\item{nested}{a boolean, \code{TRUE} for nested models}

\item{vartest}{a boolean, if \code{TRUE}, the variance test is computed}

\item{ndraws}{the number of draws for the simulations}

\item{diffnorm}{a creuser}

\item{seed}{the seed}

\item{numbers}{a user provided matrix of random numbers}

\item{nd}{a boolean, if \code{TRUE} (the default) the non-degenarate Vuong test is computed}

\item{print.level}{the level of details to be printed}
}
\value{
an object of class \code{"htest"}.
}
\description{
An unhanced version of the Vuong test with a small-sample bias
correction
}
\references{
\insertRef{VUON:89}{micsr}

\insertRef{SHI:15}{micsr}
}
\seealso{
the classical Vuong test is implemented in \code{pscl::vuong} and \code{nonnest2::vuongtest}.
}
\keyword{htest}
