% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{newton}
\alias{newton}
\title{Newton-Raphson  method for numerical optimization}
\usage{
newton(
  fun,
  coefs,
  trace = 0,
  direction = c("min", "max"),
  tol = sqrt(.Machine$double.eps),
  maxit = 500,
  ...
)
}
\arguments{
\item{fun}{the function to optimize}

\item{coefs}{a vector of starting values}

\item{trace}{if positive or true, some information about the
computation is printed}

\item{direction}{either \code{"min"} or \code{"max"}}

\item{tol}{the tolerance}

\item{maxit}{maximum number of iterations}

\item{...}{further arguments, passed to fun}
}
\value{
a numeric vector, the parameters at the optimum of the
function.
}
\description{
The Newton-Raphson method use the gradient and the hessian of a
function. For well behaved functions, it is extremely accurate.
}
\keyword{misc}
