% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mies_methods.R
\name{mies_survival_plus}
\alias{mies_survival_plus}
\title{Choose Survivors According to the "Mu + Lambda" ("Plus") Strategy}
\usage{
mies_survival_plus(inst, mu, survival_selector, ...)
}
\arguments{
\item{inst}{(\code{OptimInstance})\cr
Optimization instance to evaluate.}

\item{mu}{(\code{integer(1)})\cr
Population target size, non-negative integer.}

\item{survival_selector}{(\code{\link{Selector}})\cr
\code{\link{Selector}} operator that selects surviving individuals depending on configuration values
and objective results. When \code{survival_selector$operate()} is called, then objectives that
are being minimized are multiplied with -1 (through \code{\link{mies_get_fitnesses}}), since \code{\link{Selector}}s always try to maximize fitness.\cr
The \code{\link{Selector}} must be primed on \code{inst$search_space}; this \emph{includes} the "budget" component
when performing multi-fidelity optimization.\cr
The given \code{\link{Selector}} may \emph{not} return duplicates.}

\item{...}{(any)\cr
Ignored, for compatibility with other \verb{mies_survival_*} functions.}
}
\value{
invisible \code{\link[data.table:data.table]{data.table}}: The value of \code{inst$archive$data}, changed
in-place with \code{eol} set to the current generation for non-survivors.
}
\description{
Choose survivors during a MIES iteration using the "Plus" survival strategy, i.e.
combining all alive individuals from the latest and from prior generations indiscriminately and
choosing survivors using a survival \code{\link{Selector}} operator.

When \code{mu} is greater than the number of alive individuals, then all individuals survive.
}
\examples{
set.seed(1)
library("bbotk")
lgr::threshold("warn")

# Define the objective to optimize
objective <- ObjectiveRFun$new(
  fun = function(xs) {
    z <- exp(-xs$x^2 - xs$y^2) + 2 * exp(-(2 - xs$x)^2 - (2 - xs$y)^2)
    list(Obj = z)
  },
  domain = ps(x = p_dbl(-2, 4), y = p_dbl(-2, 4)),
  codomain = ps(Obj = p_dbl(tags = "maximize"))
)

# Get a new OptimInstance
oi <- OptimInstanceSingleCrit$new(objective,
  terminator = trm("evals", n_evals = 100)
)

mies_init_population(inst = oi, mu = 3)
offspring = generate_design_random(oi$search_space, 2)$data
mies_evaluate_offspring(oi, offspring = offspring)

# State before: different generations of individuals. Alive individuals have
# 'eol' set to 'NA'.
oi$archive

s = sel("best")
s$prime(oi$search_space)
mies_survival_plus(oi, mu = 3, survival_selector = s)

# sel("best") lets only the three best individuals survive.
# The others have 'eol = 2' (the current generation).
oi$archive
}
\seealso{
Other mies building blocks: 
\code{\link{mies_evaluate_offspring}()},
\code{\link{mies_generate_offspring}()},
\code{\link{mies_get_fitnesses}()},
\code{\link{mies_init_population}()},
\code{\link{mies_select_from_archive}()},
\code{\link{mies_step_fidelity}()},
\code{\link{mies_survival_comma}()}
}
\concept{mies building blocks}
