% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FiltorSurrogateProgressive.R
\name{dict_filtors_surprog}
\alias{dict_filtors_surprog}
\alias{FiltorSurrogateProgressive}
\title{Progressive Surrogate Model Filtering}
\description{
Performs progressive surrogate model filtering. A surrogate model is used, as described in the parent class \code{\link{FiltorSurrogate}}.
The filtering is "progressive" in that successive values are filtered more agressively.
}
\section{Algorithm}{


Given the number \code{n_filter} of of individuals to sample, and the desired pool size at round \code{i} \code{pool_size(i)}, progressive
surrogate model filtering proceeds as follows:
\enumerate{
\item Train the \code{surrogate_learner} \code{\link[mlr3:LearnerRegr]{LearnerRegr}} on the \code{known_values} and their \code{fitnesses}.
\item Take \code{pool_size(1)} configurations, predict their expected performance using the surrogate model, and put them
into a pool \code{P} of configurations to consider.
\item Initialize \code{i} to 1.
\item Take the individual that is optimal according to predicted performance, remove it from \code{P} and add it to solution set \code{S}.
\item If the number of solutions in \code{S} equals \code{n_filter}, quit.
\item If \code{pool_size(i + 1)} is larger than \code{pool_size(i)}, take the next \code{pool_size(i + 1) - pool_size(i)} configurations,
predict their expected performance using the surrogate model, and add them to \code{P}. Otherwise, remove \code{pool_size(i) - pool_size(i + 1)}
random individuals from the pool. The size of \code{P} ends up being \code{pool_size(i + 1) - i}, as \code{i} individuals have also been removed and
added to \code{S}.
\item Increment \code{i}, jump to 4.
}

(The algorithm presented here is optimized for clarity; the actual implementation does all the surrogate model prediction in one go, but is functionally
equivalent).

\code{pool_size(i)} is calculated as \code{round(n_filter * pool_factor * (pool_factor_last / pool_factor) ^ (i / n_filter))}, i.e. a log-linear interpolation from
\code{pool_factor * n_filter} to \code{pool_factor_last * n_filter}.

The \code{pool_factor} and \code{pool_factor_last} configuration parameters of this algorithm determine how agressively the surrogate model is used to
filter out sampled configurations. If the filtering is agressive (large values), then more "exploitation" at the cost of "exploration" is performed.
When \code{pool_factor} is small but \code{pool_factor_last} is large (or vice-versa), then different individuals are filtered with different agressiveness, potentially
leading to a tradeoff between "exploration" and "exploitation".

When \code{pool_factor_last} is set, it defaults to \code{pool_factor}, with no new individuals added and no individuals removed from the filter pool during filtering.
It is equivalent to taking the top \code{n_filter} individuals out of a sample of \code{n_filter * pool_factor}.
}

\section{Configuration Parameters}{

\code{FiltorSurrogateProgressive}'s configuration parameters are the hyperparameters of the \code{\link{FiltorSurrogate}} base class, as well as:
\itemize{
\item \code{filter.pool_factor} :: \code{numeric(1)}\cr
\code{pool_factor} parameter of the progressive surrogate model filtering algorithm, see the corresponding section. Initialized to 1. Together with the
default of \code{filter.pool_factor_last}, this is equivalent to random sampling new individuals.
\item \code{filter.pool_factor_last} :: \code{numeric(1)}\cr
\code{pool_factor_last} parameter of the progressive surrogate model filtering algorithm, see the corresponding section.
When not given, it defaults to \code{filter.pool_factor}, equivalent to taking the top \code{n_filter} from \code{n_filter * pool_factor} individuals.
}
}

\section{Supported Operand Types}{

See \code{\link{FiltorSurrogate}} about supported operand types.
}

\section{Dictionary}{

This \code{\link{Filtor}} can be created with the short access form \code{\link[=ftr]{ftr()}}
(\code{\link[=ftrs]{ftrs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_filtors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
ftr("surprog", <surrogate_learner> [, <surrogate_selector>])
ftrs("surprog", <surrogate_learner> [, <surrogate_selector>])  # takes vector IDs, returns list of Filtors

# long form:
dict_filtors$get("surprog", <surrogate_learner> [, <surrogate_selector>])
}\if{html}{\out{</div>}}
}

\examples{
library("mlr3")
library("mlr3learners")
fp = ftr("surprog", lrn("regr.lm"), filter.pool_factor = 2)

p = ps(x = p_dbl(-5, 5))
known_data = data.frame(x = 1:5)
fitnesses = 1:5
new_data = data.frame(x = c(2.5, 4.5))

fp$prime(p)

fp$needed_input(1)

fp$operate(new_data, known_data, fitnesses, 1)

}
\seealso{
Other filtors: 
\code{\link{Filtor}},
\code{\link{FiltorSurrogate}},
\code{\link{dict_filtors_maybe}},
\code{\link{dict_filtors_null}},
\code{\link{dict_filtors_proxy}},
\code{\link{dict_filtors_surtour}}
}
\concept{filtors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Filtor]{miesmuschel::Filtor}} -> \code{\link[miesmuschel:FiltorSurrogate]{miesmuschel::FiltorSurrogate}} -> \code{FiltorSurrogateProgressive}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FiltorSurrogateProgressive-new}{\code{FiltorSurrogateProgressive$new()}}
\item \href{#method-FiltorSurrogateProgressive-clone}{\code{FiltorSurrogateProgressive$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="Filtor" data-id="needed_input"><a href='../../miesmuschel/html/Filtor.html#method-Filtor-needed_input'><code>miesmuschel::Filtor$needed_input()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="FiltorSurrogate" data-id="prime"><a href='../../miesmuschel/html/FiltorSurrogate.html#method-FiltorSurrogate-prime'><code>miesmuschel::FiltorSurrogate$prime()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorSurrogateProgressive-new"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorSurrogateProgressive-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{FiltorSurrogateProgressive}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorSurrogateProgressive$new(
  surrogate_learner,
  surrogate_selector = SelectorBest$new()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate_learner}}{(\code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}})\cr
Regression learner for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_learner} field will reflect this value.}

\item{\code{surrogate_learner}}{(\code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}})\cr
Regression learner for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_learner} field will reflect this value.}

\item{\code{surrogate_selector}}{(\code{\link{Selector}})
\code{\link{Selector}} for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_selector} field will reflect this value.}

\item{\code{surrogate_selector}}{(\code{\link{Selector}})
\code{\link{Selector}} for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_selector} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorSurrogateProgressive-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorSurrogateProgressive-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorSurrogateProgressive$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
