% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipf2_block.R
\name{ipf2_block}
\alias{ipf2_block}
\title{Iterative Proportional Fitting Routine for the Indirect Estimation of Origin-Destination-Type Migration Flow Tables with Known Origin and Destination Margins and Block Diagonal Elements.}
\usage{
ipf2_block(rtot = NULL, ctot = NULL, btot = NULL, block = NULL,
  m = NULL, tol = 1e-05, maxit = 500, verbose = TRUE, ...)
}
\arguments{
\item{rtot}{Vector of origin totals to constrain the sum of the imputed cell rows.}

\item{ctot}{Vector of destination totals to constrain the sum of the imputed cell columns.}

\item{btot}{Matrix of block totals to constrain the sum of the imputed cell blocks.}

\item{block}{Matrix of block structure corresponding to \code{btot}.}

\item{m}{Matrix of auxiliary data. By default set to 1 for all origin-destination combinations.}

\item{tol}{Numeric value for the tolerance level used in the parameter estimation.}

\item{maxit}{Numeric value for the maximum number of iterations used in the parameter estimation.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}

\item{...}{Additional arguments passes to \code{\link{block_matrix}}.}
}
\value{
Iterative Proportional Fitting routine set up using the partial likelihood derivatives. The arguments \code{rtot} and \code{ctot} take the row-table and column-table specific known margins. The \code{btot} take the totals over the blocks in the matrix defined with \code{b}. Diagonal values can be added by the user, but care must be taken to ensure resulting diagonals are feasible given the set of margins. 

The user must ensure that the row and column totals in each table sum to the same value. Care must also be taken to allow the dimension of the auxiliary matrix (\code{m}) equal those provided in the row and column totals.

Returns a \code{list} object with
\item{mu }{Array of indirect estimates of origin-destination matrices by migrant characteristic}
\item{it }{Iteration count}
\item{tol }{Tolerance level at final iteration}
}
\description{
The \code{ipf2.b} function finds the maximum likelihood estimates for fitted values in the log-linear model:
\deqn{ \log y_{pq} = \log \alpha_{p} + \log \beta_{q} + \log \lambda_{ij}I(p \in i, q \in j) + \log m_{pq} }
where \eqn{m_{pq}} is a prior estimate for \eqn{y_{pq}} and is no more complex than the matrices being fitted. The \eqn{\lambda_{ij}I(p \in i, q \in j)} term ensures a saturated fit on the block the \eqn{(i,j)} block.
}
\examples{
y <- ipf2_block(rtot= c(30,20,30,10,20,5,0,10,5,5,5,10),
                ctot = c(45,10,10,5,5,10,50,5,10,0,0,0),
                btot = matrix(data = c(0,0 ,50,0, 35,0,25,0, 10,10,0,0, 10,10,0,0),
                              nrow = 4, byrow = TRUE),
                block = block_matrix(x = 1:16, b = c(2,3,4,3)))
addmargins(y$mu)
}
\seealso{
\code{\link{block_matrix}}, \code{\link{stripe_matrix}}, \code{\link{block_sum}}
}
\author{
Guy J. Abel
}
