% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_tests.R
\name{test_distributions}
\alias{test_distributions}
\alias{test_distribution}
\alias{test_fit}
\title{Tests of network distributions}
\usage{
test_distribution(diff_model1, diff_model2)

test_fit(diff_model, diff_models)
}
\arguments{
\item{diff_model1, diff_model2}{diff_model objects}

\item{diff_model}{A diff_model object is returned by
\code{play_diffusion()} or \code{as_diffusion()} and contains
a single empirical or simulated diffusion.}

\item{diff_models}{A diff_models object is returned by
\code{play_diffusions()} and contains a series of diffusion simulations.}
}
\description{
These functions conduct tests of distributions:
\itemize{
\item \code{test_distribution()} performs a two-sample Kolmogorov-Smirnov test on
whether two "diff_model" objects are drawn from the same distribution.
\item \code{test_fit()} performs a chi-squared test on the squared Mahalanobis distance
between a diff_model and diff_models objects.
}
}
\section{Mahalanobis distance}{

\code{test_gof()} takes a single diff_model object,
which may be a single empirical or simulated diffusion,
and a diff_models object containing many simulations.
Note that currently only the goodness of fit of the

It returns a tibble (compatible with \code{broom::glance()}) that includes
the Mahalanobis distance statistic
between the observed and simulated distributions.
It also includes a p-value summarising a chi-squared test on this statistic,
listing also the degrees of freedom and number of observations.
If the p-value is less than the convention 0.05,
then one can argue that the first diffusion is not well captured by
}

\examples{
 # test_distribution(play_diffusion(ison_networkers), 
 #                   play_diffusion(ison_networkers, thresholds = 75))
  # Playing a reasonably quick diffusion
  # x <- play_diffusion(generate_random(15), transmissibility = 0.7)
  # Playing a slower diffusion
  # y <- play_diffusions(generate_random(15), transmissibility = 0.1, times = 40)
  # plot(x)
  # plot(y)
  # test_fit(x, y)
}
\seealso{
Other models: 
\code{\link{regression}},
\code{\link{tests}}
}
\concept{models}
