% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_val.R
\name{create_grouped_k_multifolds}
\alias{create_grouped_k_multifolds}
\title{Splitting into folds for cross-validation when using groups}
\usage{
create_grouped_k_multifolds(groups, kfold = 10, cv_times = 5)
}
\arguments{
\item{groups}{equivalent to y in caret::createMultiFolds}

\item{kfold}{equivalent to k in caret::createMultiFolds}

\item{cv_times}{equivalent to cv_times in caret::createMultiFolds}
}
\value{
indices of folds for CV
}
\description{
Like \link[caret]{createMultiFolds} but still splitting by groups using \link[caret]{groupKFold}. Code modified from \link[caret]{createMultiFolds}.
}
\examples{
\dontrun{
set.seed(0)
groups <- c("A", "B", "A", "B", "C", "C", "A", "A", "D")
folds <- create_grouped_k_multifolds(groups, kfold = 2, cv_times = 2)
}
}
\author{
Zena Lapp, {zenalapp@umich.edu}
}
\keyword{internal}
