% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mild_df.R
\name{mild_df}
\alias{mild_df}
\title{Build a MILD data frame}
\usage{
mild_df(
  bag_label = character(),
  bag_name = character(),
  instance_name = character(),
  ...,
  instance_label = NULL
)
}
\arguments{
\item{bag_label}{A \code{character}, \code{factor}, or \code{numeric} vector.}

\item{bag_name}{A \code{character} or \code{factor} vector.}

\item{instance_name}{A \code{character} or \code{factor} vector.}

\item{...}{A set of name-value pairs. These construct the covariates for a
\code{mild_df}.}

\item{instance_label}{A \code{character}, \code{factor}, or \code{numeric} vector, or
\code{NULL}.}
}
\value{
A 'mild_df' object. This data.frame-like has columns \code{bag_label},
\code{bag_name}, \code{instance_name}, and those specified in \code{...}. It also inherits
from the \code{'tbl_df'} and \code{'tbl'} classes.
}
\description{
\code{mild_df()} constructs a data frame that corresponds to Multiple Instance
Learning with Distributional Instances (MILD) data.  A \code{mild_df} object must
have three special columns:
\itemize{
\item \code{bag_label}, determines the label of each bag, typically from \code{c(0, 1)}
\item \code{bag_name}, character or factor that specifies the bag that each sample
belongs to.
\item \code{instance_name}, character or factor that specifies the instance that
each sample belongs to.
}
}
\details{
We refer to the rows of a \code{mild_df} as \emph{samples}, since they are
thought of as draws from the distribution that determines each instance.
Each instance is contained in a bag, with a corresponding label.  Instance
labels can be provided, but they will be pulled in as an attribute.
}
\examples{
mild_df('bag_label' = factor(c(1, 1, 0)),
        'bag_name' = c(rep('bag_1', 2), 'bag_2'),
        'instance_name' = c('bag_1_inst_1', 'bag_1_inst_2', 'bag_2_inst_1'),
        'X1' = c(-0.4, 0.5, 2),
        'instance_label' = c(0, 1, 0))

}
\seealso{
\itemize{
\item \code{\link[=as_mild_df]{as_mild_df()}} to convert data.frames to \code{mild_df}s.
\item \code{\link[=generate_mild_df]{generate_mild_df()}} for simulating a \code{mild_df} object.
\item \code{\link[=summarize_samples]{summarize_samples()}} for summarizing the \code{mild_df} into a multiple
instance learning data set.
}
}
\author{
Yifei Liu, Sean Kent
}
