% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.LR.R
\name{boot.LR}
\alias{boot.LR}
\title{Parametric bootstrap likleihood-ratio test}
\usage{
boot.LR(mod, mod2, R = 1000)
}
\arguments{
\item{mod}{an estimated model object}

\item{mod2}{an estimated model object}

\item{R}{number of parametric bootstraps to use.}
}
\value{
a p-value evaluating whether the more restrictive model fits significantly worse
  than the less restrictive model
}
\description{
Given two fitted models, compute a parametric bootstrap test to determine whether
the less restrictive models fits significantly better than the more restricted model.
Note that this hypothesis test also works when prior parameter distributions are included for
either model. Function can be run in parallel after using a stuitable \code{\link{mirtCluster}}
definition.
}
\examples{

\dontrun{

#standard
dat <- expand.table(LSAT7)
mod1 <- mirt(dat, 1)
mod2 <- mirt(dat, 1, '3PL')

# standard LR test
anova(mod1, mod2)

# boostrap LR test (run in parallel to save time)
mirtCluster()
boot.LR(mod1, mod2, R=200)

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{bootstrap}
\keyword{parametric}

