% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMPprelim.R
\name{makeMPprelim}
\alias{makeMPprelim}
\title{Make preliminary investigation MP data simulations: a function for obtaining a database of preliminary investigation data for a missing person search.}
\usage{
makeMPprelim(
  casetype = "children",
  dateinit = "1975/01/01",
  scenario = 1,
  femaleprop = 0.5,
  ext = 100,
  numsims = 10000,
  seed = 123,
  region = c("North America", "South America", "Africa", "Asia", "Europe", "Oceania"),
  regionprob = c(0.2, 0.2, 0.2, 0.1, 0.2, 0.1)
)
}
\arguments{
\item{casetype}{Type of missing person search case. Two options are available: "migrants" or "children".}

\item{dateinit}{Minimun birth date of simulated missing person. Casetype: Children.}

\item{scenario}{Birth date distribution scenarios: (1) non-uniform, (2) uniform. Casetype: Children.}

\item{femaleprop}{Proportion of females. Casetype: All.}

\item{ext}{Time extension for minimun birth date, range in scenario 1 and days in scenario 2. Casetype: Children.}

\item{numsims}{Number of simulated MPs. Casetype: All.}

\item{seed}{Select a seed for simulations. If it is defined, results will be reproducible. Casetype: All.}

\item{region}{Birth region or place in missing children case or place of place of the last seen in missing migrant case. Casetype: All.}

\item{regionprob}{Region proportions. Casetype: All.}
}
\value{
An object of class data.frame with preliminary investigation data.
}
\description{
Make preliminary investigation MP data simulations: a function for obtaining a database of preliminary investigation data for a missing person search.
}
\examples{
makeMPprelim()

}
