% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combLR.R
\name{combLR}
\alias{combLR}
\title{Combine LRs: a function for combining LRs obtained from simulations.}
\usage{
combLR(LRdatasim1, LRdatasim2)
}
\arguments{
\item{LRdatasim1}{A data frame object with the results of simulations. Outputs from simLRgen or simLRprelim funcionts.}

\item{LRdatasim2}{A second data frame object with the results of simulations. Outputs from simLRgen or simLRprelim funcionts.}
}
\value{
An object of class data.frame combining the LRs obtained from simulations (the function multiplies the LRs).
}
\description{
Combine LRs: a function for combining LRs obtained from simulations.
}
\examples{
library(mispitools)
library(forrel) 
x = linearPed(2)
x = setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x = profileSim(x, N = 1, ids = 2)
LRdatasim1 = simLRgen(x, missing = 5, 10, 123)
LRdatasim2 = simLRprelim("sex")
combLR(LRdatasim1,LRdatasim2)
}
