% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_1_to_x.R
\name{delete_MNAR_1_to_x}
\alias{delete_MNAR_1_to_x}
\title{Create MNAR values using MNAR1:x}
\usage{
delete_MNAR_1_to_x(
  ds,
  p,
  cols_mis,
  x,
  cutoff_fun = median,
  prop = 0.5,
  use_lpSolve = TRUE,
  ordered_as_unordered = FALSE,
  stochastic = FALSE,
  add_realized_x = FALSE,
  ...,
  miss_cols
)
}
\arguments{
\item{ds}{A data frame or matrix in which missing values will be created.}

\item{p}{A numeric vector with length one or equal to length \code{cols_mis};
the probability that a value is missing.}

\item{cols_mis}{A vector of column names or indices of columns in which
missing values will be created.}

\item{x}{Numeric with length one (0 < x < \code{Inf}); odds are 1 to x for
the probability of a value to be missing in group 1 against the probability
of a value to be missing  in group 2 (see details).}

\item{cutoff_fun}{Function that calculates the cutoff values in the
\code{cols_ctrl}.}

\item{prop}{Numeric of length one; (minimum) proportion of rows in group 1
(only used for unordered factors).}

\item{use_lpSolve}{Logical; should lpSolve be used for the determination of
groups, if \code{cols_ctrl[i]} is an unordered factor.}

\item{ordered_as_unordered}{Logical; should ordered factors be treated as
unordered factors.}

\item{stochastic}{Logical; see details.}

\item{add_realized_x}{Logical; if TRUE the realized odds for cols_mis will
be returned (as attribute).}

\item{...}{Further arguments passed to \code{cutoff_fun}.}

\item{miss_cols}{Deprecated, use cols_mis instead.}
}
\value{
An object of the same class as \code{ds} with missing values.
}
\description{
Create missing not at random (MNAR) values using MNAR1:x in a data frame or
a matrix
}
\details{
The functions \code{delete_MNAR_1_to_x} and \code{\link{delete_MAR_1_to_x}} are sisters. The only difference between these two functions is the column that controls the generation of missing values. In \code{\link{delete_MAR_1_to_x}} a separate column \code{cols_ctrl[i]} controls the generation of missing values in \code{cols_mis[i]}. In contrast, in \code{delete_MNAR_1_to_x} the generation of missing values in \code{cols_mis[i]} is controlled by \code{cols_mis[i]} itself. All other aspects are identical for both functions. Therefore, further details can be found in \code{\link{delete_MAR_1_to_x}}.
}
\examples{
ds <- data.frame(X = 1:20, Y = 101:120)
delete_MNAR_1_to_x(ds, 0.2, "X", x = 3)
}
\references{
Santos, M. S., Pereira, R. C., Costa, A. F., Soares, J. P.,
  Santos, J., & Abreu, P. H. (2019). Generating Synthetic Missing Data: A
  Review by Missing Mechanism. \emph{IEEE Access}, 7, 11651-11667
}
\seealso{
\code{\link{delete_MAR_1_to_x}}

Other functions to create MNAR: 
\code{\link{delete_MNAR_censoring}()},
\code{\link{delete_MNAR_one_group}()},
\code{\link{delete_MNAR_rank}()}
}
\concept{functions to create MNAR}
