% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_LS_array.R
\name{impute_LS_array}
\alias{impute_LS_array}
\title{LSimpute_array}
\usage{
impute_LS_array(
  ds,
  k = 10,
  eps = 1e-06,
  min_common_obs = 5,
  ds_impute_LS_gene = NULL,
  verbose_gene = FALSE,
  verbose_expected_values = FALSE
)
}
\arguments{
\item{ds}{A data frame or matrix with missing values.}

\item{k}{Directly passed to \code{\link[=impute_LS_gene]{impute_LS_gene()}}.}

\item{eps}{Directly passed to \code{\link[=impute_LS_gene]{impute_LS_gene()}}.}

\item{min_common_obs}{Directly passed to \code{\link[=impute_LS_gene]{impute_LS_gene()}}.}

\item{ds_impute_LS_gene}{Result of imputing \code{ds} with \code{ds_impute_LS_gene()},
if this already exists (see details).}

\item{verbose_gene}{Should \code{impute_LS_gene()} be \code{verbose}?}

\item{verbose_expected_values}{Should \code{impute_expected_values()} be \code{verbose}?}
}
\value{
An object of the same class as \code{ds} with imputed missing values.
}
\description{
Perform LSimpute_array as described by Bo et al. (2004)
}
\details{
This function performs LSimpute_array as described by Bo et al. (2004).The function assumes that the genes are the rows of \code{ds}.

The mean vector and covariance matrix for the imputation in LSimpute_array is
based on a imputed dataset from LSimpute_gene. This dataset can be supplied
directly via \code{ds_impute_LS_gene} or will automatically be created with
\code{\link[=impute_LS_gene]{impute_LS_gene()}} (if \code{ds_impute_LS_gene} is \code{NULL}). The imputation values
are the expected values given the estimated parameters and the observed
values. They are calculated via \code{\link[=impute_expected_values]{impute_expected_values()}}. The amount of
feedback from these two functions is controlled via \code{verbose_gene}  and
\code{verbose_expected_values}. The values of these two arguments are passed on to
the argument \code{verbose} from \code{impute_LS_gene()} and
\code{impute_expected_values()}.
}
\examples{
set.seed(123)
ds_mis <- delete_MCAR(mvtnorm::rmvnorm(100, rep(0, 10)), 0.1)
ds_imp <- impute_LS_array(ds_mis)
}
\references{
Bo, T. H., Dysvik, B., & Jonassen, I. (2004). LSimpute: accurate estimation of missing values in microarray data with least squares methods. Nucleic acids research, 32(3), e34
}
\seealso{
Other LSimpute functions: 
\code{\link{impute_LS_adaptive}()},
\code{\link{impute_LS_combined}()},
\code{\link{impute_LS_gene}()}
}
\concept{LSimpute functions}
