% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.missingHE.R
\name{plot.missingHE}
\alias{plot.missingHE}
\title{Plot method for the imputed data contained in the objects of class \code{missingHE}}
\usage{
\method{plot}{missingHE}(x, prob = c(0.05, 0.95), class = "scatter",
  outcome = "all", theme = NULL, ...)
}
\arguments{
\item{x}{A \code{missingHE} object containing the results of the Bayesian model for cost-effectiveness analysis.}

\item{prob}{A numeric vector of probabilities within range [0, 1], representing the upper and lower
CI sample quantiles to be calculated and returned for the imputed values.}

\item{class}{Type of the plot comparing the observed and imputed outcome data. Available choices are
'histogram' and 'scatter' for a histogram or a scatter plot of the observed and imputed outcome data, respectively.}

\item{outcome}{The outcome variables that should be displayed. Options are: 'all' (default) which shows the plots
for both treatment arms and types of outcome variables; 'effects' and 'costs' which show the plots for the corresponding
outcome variables in both arms; 'arm1' and 'arm2' which show the plots by the selected treatment arm. To select
the plots for a specific outcome in a specific treatment arm the options that can be used are 'effects_arm1',
'effects_arm2', 'costs_arm1' or 'costs_arm2'.}

\item{theme}{Type of ggplot theme among some pre-defined themes, mostly taken from the package \strong{ggthemes}. For a full list of available themes see details.}

\item{...}{Additional parameters that can be provided to manage the output of \code{plot.missingHE}.}
}
\value{
A \code{ggplot} object containing the plots specified in the argument \code{class}.
}
\description{
Produces a plot of the observed and imputed values (with credible intervals) for the effect and cost outcomes from a
Bayesian cost-effectiveness analysis model with two treatment arms, implemented using the function \code{\link{selection}}, \code{\link{pattern}} or \code{\link{hurdle}}.
The graphical layout is obtained from the functions contained in the package \strong{ggplot2} and \strong{ggthemes}.
}
\details{
The funciton produces a plot of the observed and imputed effect and cost data in a two-arm based 
cost-effectiveness model implemented using the function \code{\link{selection}}, \code{\link{pattern}} or \code{\link{hurdle}}. The purpose of this graph
is to visually compare the outcome values for the fully-observed individuals with those imputed by the model for the missing individuals.
For the scatter plot, imputed values are also associated with the credible intervals specified in the argument \code{prob}.
The argument \code{theme} allows to customise the graphical aspect of the plots generated by \code{plot.missingHE} and
allows to choose among a set of possible pre-defined themes taken form the package \strong{ggtheme}. For a complete list of the available character names
for each theme and scheme set, see \strong{ggthemes} and \strong{bayesplot}.
}
\examples{
#For examples see the function selection, pattern or hurdle
#
#
}
\references{
Daniels, MJ. Hogan, JW. (2008) \emph{Missing Data in Longitudinal Studies: strategies for Bayesian modelling and sensitivity analysis}, CRC/Chapman Hall.

Molenberghs, G. Fitzmaurice, G. Kenward, MG. Tsiatis, A. Verbeke, G. (2015) \emph{Handbook of Missing Data Methodology}, CRC/Chapman Hall.
}
\seealso{
\code{\link{selection}} \code{\link{pattern}} \code{\link{hurdle}} \code{\link{diagnostic}}
}
\author{
Andrea Gabrio
}
\keyword{data}
\keyword{missing}
\keyword{plot}
