% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cohens.d.R
\name{print.cohens.d}
\alias{print.cohens.d}
\title{Print cohens.d object}
\usage{
\method{print}{cohens.d}(x, digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{cohens.d} object.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying results.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{cohens.d} object
}
\examples{
#--------------------------------------
# Between-subject design
dat.bs <- data.frame(group = c("cont", "cont", "cont", "treat",  "treat"),
                     y1 = c(1, 3, 2, 5, 7),
                     y2 = c(4, 3, 3, 6, 4),
                     y3 = c(7, 5, 7, 3, 2))

# Standardized mean difference divided by the weighted pooled
# standard deviation without small sample correction factor
dat.bs.d <- cohens.d(y1 ~ group, data = dat.bs, output = FALSE)

# Print cohens.d object with 5 digits
print(dat.bs.d, digits = 5)

#--------------------------------------
# Within-subject design
dat.ws <- data.frame(pre = c(1, 3, 2, 5, 7),
                     post = c(2, 2, 1, 6, 8))

# Standardized mean difference divided by the pooled
# standard deviation while controlling for the correlation
# without small sample correction factor
dat.ws.d <- cohens.d(post ~ pre, data = dat.ws, paired = TRUE, output = FALSE)

# Print cohens.d object with 5 digits
print(dat.ws.d, digits = 5)
}
\seealso{
\code{\link{cohens.d}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
