% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.na.auxiliary.R
\name{print.na.auxiliary}
\alias{print.na.auxiliary}
\title{Print na.auxiliary object}
\usage{
\method{print}{na.auxiliary}(x, tri = x$args$tri, digits = x$args$digits,
      check = TRUE, ...)
}
\arguments{
\item{x}{\code{na.auxiliary} object.}

\item{tri}{a character string indicating which triangular of the matrix to show on the console,
i.e., \code{both} for upper and lower triangular, \code{lower} for the lower triangular,
and \code{upper} for the upper triangular.}

\item{digits}{integer value indicating the number of decimal places digits to be used for displaying
correlation coefficients and Cohen's d estimates.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{na.auxiliary} object
}
\examples{
dat <- data.frame(x1 = c(1, NA, 2, 5, 3, NA, 5, 2),
                  x2 = c(4, 2, 5, 1, 5, 3, 4, 5),
                  x3 = c(NA, 3, 2, 4, 5, 6, NA, 2),
                  x4 = c(5, 6, 3, NA, NA, 4, 6, NA))

# Auxiliary variables
dat.na.auxiliary <- na.auxiliary(dat, output = FALSE)

# Print na.auxiliary object with 3 digits
print(dat.na.auxiliary, digits = 3)
}
\seealso{
\code{\link{na.auxiliary}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
