% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.crosstab.R
\name{print.crosstab}
\alias{print.crosstab}
\title{Print crosstab}
\usage{
\method{print}{crosstab}(x, print = x$args$print, freq = x$args$freq, split = x$args$split,
      digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{crosstab} object.}

\item{print}{a character string or character vector indicating which percentage(s) to be printed on the
console, i.e., no percentages (\code{"no"}) (default), all percentages (\code{"all"}),
row-wise percentages (\code{"row"}), column-wise percentages (\code{"col"}), and
total percentages (\code{"total"}).}

\item{freq}{logical: if \code{TRUE}, absolute frequencies will be included in the cross tabulation.}

\item{split}{logical: if \code{TRUE}, output table is split in absolute frequencies and percentage(s).}

\item{digits}{an integer indicating the number of decimal places digits to be used for displaying percentages.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{crosstab} object
}
\examples{
\dontrun{
dat <- data.frame(x1 = c(1, 2, 2, 1, 1, 2, 2, 1, 1, 2),
                  x2 = c(NA, 2, 2, 1, 2, 1, 1, 1, 2, 1),
                  x3 = c(1, 2, 1, 1, 1, 2, 2, 2, 2, 1))

# Cross Tabulation for x1 and x2
dat.crosstab <- crosstab(dat[, c("x1", "x2")], output = FALSE)

# Print crosstab object with 3 digits for displaying percentages
print(dat.crosstab, digits = 3)
}
}
\seealso{
\code{\link{crosstab}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
