% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.indicator.R
\name{na.indicator}
\alias{na.indicator}
\title{Missing Data Indicator Matrix}
\usage{
na.indicator(..., data = NULL, as.na = NULL, check = TRUE)
}
\arguments{
\item{...}{a matrix or data frame with incomplete data, where missing
values are coded as \code{NA}. Alternatively, an expression
indicating the variable names in \code{data} e.g.,
\code{na.indicator(x1, x2, x3, data = dat)}. Note that the operators
\code{.}, \code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{data}{a data frame when specifying one or more variables in the
argument \code{...}. Note that the argument is \code{NULL}
when specifying a matrix or data frame for the argument \code{...}.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns a matrix or data frame with \eqn{r = 1} if a value is observed, and \eqn{r = 0}
if a value is missing.
}
\description{
This function creates a missing data indicator matrix \eqn{R} that denotes whether
values are observed or missing, i.e., \eqn{r = 1} if a value is observed, and
\eqn{r = 0} if a value is missing.
}
\examples{
# Example 1a: Create missing data indicator matrix \eqn{R}
na.indicator(airquality)

# Example 1b: Alternative specification using the 'data' argument
na.indicator(., data = airquality)
}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. Guilford Press.

Graham, J. W. (2009). Missing data analysis: Making it work in the real world.
\emph{Annual Review of Psychology, 60}, 549-576.
https://doi.org/10.1146/annurev.psych.58.110405.085530

van Buuren, S. (2018). \emph{Flexible imputation of missing data} (2nd ed.). Chapman & Hall.
}
\seealso{
\code{\link{as.na}}, \code{\link{na.as}}, \code{\link{na.auxiliary}},
\code{\link{na.coverage}}, \code{\link{na.descript}}, \code{\link{na.pattern}},
\code{\link{na.prop}}, \code{\link{na.test}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
