% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descript.R
\name{descript}
\alias{descript}
\title{Descriptive Statistics}
\usage{
descript(..., data = NULL,
        print = c("all", "n", "nNA", "pNA", "m", "se.m", "var", "sd", "min",
                  "p25", "med", "p75", "max", "range", "iqr", "skew", "kurt"),
        group = NULL, split = NULL, sort.var = FALSE, na.omit = FALSE, digits = 2,
        as.na = NULL, write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{...}{a numeric vector, matrix or data frame with numeric variables,
i.e., factors and character variables are excluded from \code{...}
before conducting the analysis. Alternatively, an expression
indicating the variable names in \code{data} e.g.,
\code{descript(x1, x2, x3, data = dat)}. Note that the operators
\code{.}, \code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{data}{a data frame when specifying one or more variables in the
argument \code{...}. Note that the argument is \code{NULL}
when specifying a numeric vector, matrix, or data frame for
the argument \code{...}.}

\item{print}{a character vector indicating which statistical measures to be
printed on the console, i.e. \code{n} (number of observations),
\code{nNA} (number of missing values), \code{pNA} (percentage of
missing values), \code{m} (arithmetic mean), \code{se.m} (standard
error of the arithmetic mean), \code{var} (variance), \code{sd}
(standard deviation), \code{med} (median),\code{min} (minimum),
\code{p25} (25th percentile, first quartile), \code{p75} (75th
percentile, third quartile), \code{max} (maximum),  \code{range}
(range), \code{iqr} (interquartile range), \code{skew} (skewness),
and \code{kurt} (excess kurtosis). The default setting is
\code{print = ("n", "nNA", "pNA", "m", "sd", "min", "max", "skew", "kurt")}.}

\item{group}{a numeric vector, character vector or factor as grouping variable.
Alternatively, a character string indicating the variable name
of the grouping variable in \code{data} can be specified.}

\item{split}{a numeric vector, character vector or factor as split variable.
Alternatively, a character string indicating the variable name
of the split variable in \code{data} can be specified.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when
specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before
conducting the analysis (i.e., listwise deletion).}

\item{digits}{an integer value indicating the number of decimal places to be
used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis. Note that \code{as.na()} function is only applied
to \code{...}, but not to \code{group} or \code{split}.}

\item{write}{a character string naming a file for writing the output into
either a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}) or Excel file with file extention
\code{".xlsx"}  (e.g., \code{"Output.xlsx"}). If the file
name does not contain any file extension, an Excel file will
be written.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{list with the input specified in \code{...}, \code{group},
                     and \code{split}}
  \item{\code{args}}{specification of function arguments}
  \item{\code{result}}{result table(s)}
}
\description{
This function computes summary statistics for one or more than one variables, optionally
by a grouping and/or split variable.
}
\examples{
# Example 1a: Descriptive statistics for 'mpg'
descript(mtcars$mpg)

# Example 1b: Alternative specification using the 'data' argument
descript(mpg, data = mtcars)

# Example 2: Descriptive statistics, print results with 3 digits
descript(mtcars$mpg, digits = 3)

# Example 3: Descriptive statistics for x1, print all available statistical measures
descript(mtcars$mpg, print = "all")

# Example 4a: Descriptive statistics for 'mpg', 'cyl', and 'disp'
descript(mtcars[, c("mpg", "cyl", "disp")])

# Example 4b: Alternative specification using the 'data' argument
descript(mpg:disp, data = mtcars)

# Example 5a: Descriptive statistics, analysis by 'vs' separately
descript(mtcars[, c("mpg", "cyl", "disp")], group = mtcars$vs)

# Example 5b: Alternative specification using the 'data' argument
descript(mpg:disp, data = mtcars, group = "vs")

# Example 6: Descriptive statistics, analysis by 'vs' separately, sort by variables
descript(mtcars[, c("mpg", "cyl", "disp")], group = mtcars$vs, sort.var = TRUE)

# Example 7: Descriptive statistics, split analysis by 'am'
descript(mtcars[, c("mpg", "cyl", "disp")], split = mtcars$am)

# Example 8a: Descriptive statistics,analysis by 'vs' separately, split analysis by 'am'
descript(mtcars[, c("mpg", "cyl", "disp")], group = mtcars$vs, split = mtcars$am)

# Example 8b: Alternative specification using the 'data' argument
descript(mpg:disp, data = mtcars, group = "vs", split = "am")

\dontrun{
# Example 11a: Write results into a text file
descript(mtcars[, c("mpg", "cyl", "disp")], write = "Descript.txt")

# Example 11b: Write results into an Excel file
descript(mtcars[, c("mpg", "cyl", "disp")], write = "Descript.xlsx")

result <- descript(mtcars[, c("mpg", "cyl", "disp")], output = FALSE)
write.result(result, "Descript.xlsx")
}
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology
- Using R and SPSS}. John Wiley & Sons.
}
\seealso{
\code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}},
\code{\link{ci.prop}}, \code{\link{ci.prop.diff}}, \code{\link{ci.var}},
\code{\link{ci.sd}}, \code{\link{freq}}, \code{\link{crosstab}},
\code{\link{multilevel.descript}}, \code{\link{na.descript}}.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
