% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UV.R
\name{UV}
\alias{UV}
\title{Computation Of The Sufficient Statistics}
\usage{
UV(X, model, random, fixed, times)
}
\arguments{
\item{X}{matrix of the M trajectories.}

\item{model}{name of the SDE: 'OU' (Ornstein-Uhlenbeck) or 'CIR' (Cox-Ingersoll-Ross).}

\item{random}{random effects in the drift: 1 if one additive random effect, 2 if one multiplicative random effect or c(1,2) if 2 random effects.}

\item{fixed}{fixed effects in the drift: value of the fixed effect when there is only one random effect, 0 otherwise.}

\item{times}{times vector of observation times.}
}
\value{
\item{U}{vector of the M statistics U(Tend)}
\item{V}{list of the M matrices V(Tend)}
}
\description{
Computation of U and V, the two sufficient statistics of the likelihood of the mixed SDE
 \eqn{dX_j(t)= (\alpha_j- \beta_j X_j(t))dt + \sigma a(X_j(t)) dW_j(t)}.
}
\details{
Computation of U and V, the two sufficient statistics of the likelihood of the mixed SDE
\eqn{dX_j(t)= (\alpha_j- \beta_j X_j(t))dt + \sigma a(X_j(t)) dW_j(t) = (\alpha_j, \beta_j)b(X_j(t))dt + \sigma a(X_j(t)) dW_j(t)} with \eqn{b(x)=(1,-x)^t}:

U : \eqn{U(Tend) = \int_0^{Tend} b(X(s))/a^2(X(s))dX(s) }
 
V : \eqn{V(Tend) = \int_0^{Tend} b(X(s))^2/a^2(X(s))ds }
}
\references{
See Bidimensional random effect estimation in mixed stochastic differential model, C. Dion and V. Genon-Catalot, \emph{Stochastic Inference for Stochastic Processes 2015, Springer Netherlands} \bold{1--28}
}
