% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist-binom.R, R/dist-pois.R
\name{Find Vertices}
\alias{Find Vertices}
\alias{find.vertices.nonneg}
\alias{find.vertices.prob}
\title{Compute vertices for Mixture Link}
\usage{
find.vertices.prob(mean, Pi, tol = 1e-08)

find.vertices.nonneg(mean, Pi)
}
\arguments{
\item{mean}{Parameter \eqn{\vartheta} of distribution.}

\item{Pi}{Parameter \eqn{\bm{\pi}} of distribution.}

\item{tol}{A tolerance to determine if candidate vertices are distinct.}
}
\value{
A \eqn{J \times k} matrix whose columns are the vertices of
        \eqn{A(\vartheta, \bm{\pi})}.
}
\description{
Find vertices of the set \eqn{A(\vartheta, \bm{\pi})}, which characterizes
link between finite mixture mean and regression function.
}
\details{
For Mixture Link Binomial, the set \eqn{A(\vartheta, \bm{\pi}) =
\{ \bm{\mu} \in [0,1]^J : \bm{\mu}^T \bm{\pi} = \vartheta \}. }
For Mixture Link Poisson, the set \eqn{A(\vartheta, \bm{\pi}) =
\{ \bm{\mu} \in [0,\infty]^J : \bm{\mu}^T \bm{\pi} = \vartheta \}. }
}
\references{
Andrew M. Raim, Nagaraj K. Neerchal, and Jorge G. Morel.
            An Extension of Generalized Linear Models to Finite
            Mixture Outcomes. arXiv preprint: 1612.03302
}

