% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\docType{methods}
\name{getYield}
\alias{getYield}
\alias{getYield,MizerSim-method}
\title{Calculate the total yield of each species}
\usage{
getYield(object)

\S4method{getYield}{MizerSim}(object)
}
\arguments{
\item{object}{An object of class \code{MizerSim}.}
}
\value{
An array containing the total yield (time x species)
}
\description{
Calculates the total yield of each species across all gears at each
simulation time step.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
sim <- project(params, effort=1, t_max=10)
y <- getYield(sim)
}
}
\seealso{
\code{\link{getYieldGear}}
}
