% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getRDD}
\alias{getRDD}
\title{Get density dependent reproduction rate}
\usage{
getRDD(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  rdi = getRDI(params, n = n, n_pp = n_pp, n_other = n_other)
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{rdi}{A vector of density-independent reproduction rates for each
species. If not specified, rdi is calculated internally using
\code{\link[=getRDI]{getRDI()}}.}
}
\value{
A numeric vector the length of the number of species.
}
\description{
Calculates the density dependent rate of egg production \eqn{R_i} (units
1/year) for each species. This is the flux entering the smallest size class
of each species. The density dependent rate is the density independent
rate obtained with \code{\link[=getRDI]{getRDI()}} after it has been put through the
density dependence function. This is the Beverton-Holt function
\code{\link[=BevertonHoltRDD]{BevertonHoltRDD()}} by default, but this can be changed. See
\code{\link[=setReproduction]{setReproduction()}} for more details.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the rate at a particular time step
getRDD(params,sim@n[21,,],sim@n_pp[21,])
}
}
\seealso{
\code{\link[=getRDI]{getRDI()}}

Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDI}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
