% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotYieldGear}
\alias{plotYieldGear}
\alias{plotlyYieldGear}
\title{Plot the total yield of each species by gear through time}
\usage{
plotYieldGear(sim, species, total = FALSE, highlight = NULL, ...)

plotlyYieldGear(sim, species, total = FALSE, highlight = NULL, ...)
}
\arguments{
\item{sim}{An object of class \linkS4class{MizerSim}}

\item{species}{Name or vector of names of the species to be plotted. By
default all species are plotted.}

\item{total}{A boolean value that determines whether the total over all
species in the system is plotted as well. Default is FALSE}

\item{highlight}{Name or vector of names of the species to be highlighted.}

\item{...}{Other arguments (currently unused)}
}
\value{
A plot
}
\description{
After running a projection, the total yield of each species by fishing gear
can be plotted against time.
}
\details{
This plot is pretty easy to do by hand. It just
gets the biomass using the \code{\link[=getYieldGear]{getYieldGear()}} method and plots using
the ggplot2 package. You can then fiddle about with colours and linetypes
etc. Just look at the source code for details.
}
\examples{
\donttest{
params <- suppressMessages(newMultispeciesParams(NS_species_params_gears, inter))
sim <- project(params, effort=1, t_max=20, t_save = 0.2, progress_bar = FALSE)
plotYieldGear(sim)
plotYieldGear(sim, species = c("Cod", "Herring"), total = TRUE)
}
}
\seealso{
\code{\link[=plotting_functions]{plotting_functions()}},  \code{\link[=getYieldGear]{getYieldGear()}}

Other plotting functions: 
\code{\link{plot,MizerSim,missing-method}},
\code{\link{plotBiomass}()},
\code{\link{plotDiet}()},
\code{\link{plotFMort}()},
\code{\link{plotFeedingLevel}()},
\code{\link{plotGrowthCurves}()},
\code{\link{plotPredMort}()},
\code{\link{plotSpectra}()},
\code{\link{plotYield}()},
\code{\link{plotting_functions}}
}
\concept{plotting functions}
