% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getMort}
\alias{getMort}
\title{Get total mortality rate}
\usage{
getMort(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  effort = getInitialEffort(params),
  f_mort = getFMort(params, effort),
  pred_mort = getPredMort(params, n = n, n_pp = n_pp, n_other = n_other)
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{effort}{A numeric vector of the effort by gear or a single numeric
effort value which is used for all gears.}

\item{f_mort}{A two dimensional array (species x size) of fishing mortality
(optional).If not supplied is calculated using the \code{\link[=getFMort]{getFMort()}}
function.}

\item{pred_mort}{A two dimensional array of predation mortality (optional). Has
dimensions no. sp x no. size bins in the community. If not supplied is
calculated using the \code{\link[=getPredMort]{getPredMort()}} function.}
}
\value{
A two dimensional array (prey species x prey size).
}
\description{
Calculates the total mortality rate \eqn{\mu_i(w)}  (in units 1/year) on each
species by size from predation mortality, background mortality and fishing
mortality for a single time step.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the total mortality at a particular time step
getMort(params,sim@n[21,,],sim@n_pp[21,],effort=0.5)
}
}
\seealso{
\code{\link[=getPredMort]{getPredMort()}}, \code{\link[=getFMort]{getFMort()}}

Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
