% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerResourceMort}
\alias{mizerResourceMort}
\title{Get predation mortality rate for resource needed to project standard mizer
model}
\usage{
mizerResourceMort(params, n, n_pp, n_other, pred_rate, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{pred_rate}{A two dimensional array (predator species x prey size) with
the predation rate, where the prey size runs over fish community plus
resource spectrum.}

\item{...}{Optional arguments for rate functions.}
}
\value{
A vector of mortality rate by resource size.
}
\description{
Calculates the predation mortality rate \eqn{\mu_p(w)} on the resource
spectrum by resource size (in units 1/year).
}
\details{
Used by the \code{project} function for running size based simulations.
}
\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()}
}
\concept{mizer rate functions}
