% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{RickerRDD}
\alias{RickerRDD}
\title{Ricker function to calculate density-dependent reproduction rate}
\usage{
RickerRDD(rdi, species_params, ...)
}
\arguments{
\item{rdi}{Vector of density-independent reproduction rates
\eqn{R_{di}}{R_di} for all species.}

\item{species_params}{A species parameter dataframe. Must contain a column
\code{ricker_b} holding the coefficient b.}

\item{...}{Unused}
}
\value{
Vector of density-dependent reproduction rates.
}
\description{
Takes the density-independent rates \eqn{R_{di}}{R_di} of egg production and returns
reduced, density-dependent rates \eqn{R_{dd}}{R_dd} given as
\deqn{R_{dd} = R_{di} \exp{- b R_{di}}}{R_dd = R_di \exp{- b R_di}}
}
\seealso{
Other functions calculating density-dependent reproduction rate: 
\code{\link{BevertonHoltRDD}()},
\code{\link{SheperdRDD}()},
\code{\link{constantRDD}()},
\code{\link{noRDD}()}
}
\concept{functions calculating density-dependent reproduction rate}
