% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotYield}
\alias{plotYield}
\alias{plotlyYield}
\title{Plot the total yield of species through time}
\usage{
plotYield(sim, sim2, species, total = FALSE, log = TRUE, highlight = NULL, ...)

plotlyYield(
  sim,
  sim2,
  species,
  total = FALSE,
  log = TRUE,
  highlight = NULL,
  ...
)
}
\arguments{
\item{sim}{An object of class \linkS4class{MizerSim}}

\item{sim2}{An optional second object of class \linkS4class{MizerSim}. If
this is provided its yields will be shown on the same plot in bolder lines.}

\item{species}{Name or vector of names of the species to be plotted. By
default all species are plotted.}

\item{total}{A boolean value that determines whether the total over all
species in the system is plotted as well. Default is FALSE}

\item{log}{Boolean whether yield should be plotted on a logarithmic axis.
Defaults to true.}

\item{highlight}{Name or vector of names of the species to be highlighted.}

\item{...}{Other arguments (currently unused)}
}
\value{
A plot
}
\description{
After running a projection, the total yield of each species across all
fishing gears can be plotted against time. The yield is obtained with
\code{\link[=getYield]{getYield()}}.
}
\examples{
\donttest{
params <- suppressMessages(newMultispeciesParams(NS_species_params_gears, inter))
sim <- project(params, effort=1, t_max=20, t_save = 0.2, progress_bar = FALSE)
plotYield(sim)
plotYield(sim, species = c("Cod", "Herring"), total = TRUE)

# Comparing with yield from twice the effort
sim2 <- project(params, effort=2, t_max=20, t_save = 0.2, progress_bar = FALSE)
plotYield(sim, sim2, species = c("Cod", "Herring"), log = FALSE)
}
}
\seealso{
\link{plotting_functions},  \code{\link[=getYield]{getYield()}}

Other plotting functions: 
\code{\link{plot,MizerSim,missing-method}},
\code{\link{plotBiomass}()},
\code{\link{plotDiet}()},
\code{\link{plotFMort}()},
\code{\link{plotFeedingLevel}()},
\code{\link{plotGrowthCurves}()},
\code{\link{plotPredMort}()},
\code{\link{plotSpectra}()},
\code{\link{plotYieldGear}()},
\code{\link{plotting_functions}}
}
\concept{plotting functions}
