## ---- eval=FALSE--------------------------------------------------------------
#  install.packages("mizer")

## -----------------------------------------------------------------------------
library(mizer)

## ---- eval=FALSE--------------------------------------------------------------
#  install.packages("devtools")

## ---- eval=FALSE--------------------------------------------------------------
#  devtools::install_github("sizespectrum/mizer")

## -----------------------------------------------------------------------------
params <- newCommunityParams()

## -----------------------------------------------------------------------------
params <- newMultispeciesParams(NS_species_params, inter)

## -----------------------------------------------------------------------------
sim <- project(params, t_max = 10, effort = 0)

## -----------------------------------------------------------------------------
plot(sim)

## -----------------------------------------------------------------------------
getProportionOfLargeFish(sim, 
                         species = "Herring", 
                         threshold_w = 50, 
                         biomass_proportion = TRUE)

