% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerMort}
\alias{mizerMort}
\title{Get total mortality rate needed to project standard mizer model}
\usage{
mizerMort(params, n, n_pp, n_other, t, f_mort, pred_mort, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{f_mort}{A two dimensional array (species x size) with the fishing
mortality}

\item{pred_mort}{A two dimensional array (species x size) with the predation
mortality}

\item{...}{Unused}
}
\value{
A named two dimensional array (species x size) with the total
mortality rates.
}
\description{
Calculates the total mortality rate \eqn{\mu_i(w)}  (in units 1/year) on each
species by size from predation mortality, background mortality and fishing
mortality.
You would not usually call this
function directly but instead use \code{\link[=getMort]{getMort()}}, which then calls this
function unless an alternative function has been registered, see below.
}
\details{
If your model contains additional components that you added with
\code{\link[=setComponent]{setComponent()}} and for which you specified a \code{mort_fun} function then
the mortality inflicted by these components will be included in the returned
value.
}
\section{Your own mortality function}{

By default \code{\link[=getMort]{getMort()}} calls \code{\link[=mizerMort]{mizerMort()}}. However you can
replace this with your own alternative mortality function. If
your function is called \code{"myMort"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "Mort", "myMort")
}

Your function will then be called instead of \code{\link[=mizerMort]{mizerMort()}}, with the
same arguments.
}

\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
