% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_dynamics.R
\name{resource_constant}
\alias{resource_constant}
\title{Keep resource abundance constant}
\usage{
resource_constant(params, n_pp, ...)
}
\arguments{
\item{params}{A \link{MizerParams} object}

\item{n_pp}{A vector of the resource abundance by size}

\item{...}{Unused}
}
\value{
Vector containing resource spectrum at next timestep
}
\description{
If you set your resource dynamics to use this function then the resource
abundances are kept constant over time.
}
\details{
To set your model to keep the resource constant over time you do

\if{html}{\out{<div class="sourceCode">}}\preformatted{resource_dynamics(params) <- "resource_constant"
}\if{html}{\out{</div>}}

where you should replace \code{params} with the name of the variable holding your
MizerParams object.
}
\examples{
params <- NS_params
resource_dynamics(params) <- "resource_constant"
}
\seealso{
Other resource dynamics: 
\code{\link{resource_logistic}()},
\code{\link{resource_semichemostat}()}
}
\concept{resource dynamics}
