% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkinds.R
\name{mkindsg}
\alias{mkindsg}
\alias{print.mkindsg}
\title{A class for dataset groups for mkin}
\usage{
\method{print}{mkindsg}(x, data = FALSE, verbose = data, ...)
}
\arguments{
\item{x}{An \link{mkindsg} object.}

\item{data}{Should the mkinds objects be printed with their data?}

\item{verbose}{Should the mkinds objects be printed?}

\item{\dots}{Not used.}
}
\description{
A container for working with datasets that share at least one compound,
so that combined evaluations are desirable.

Time normalisation factors are initialised with a value of 1 for each
dataset if no data are supplied.
}
\examples{

mdsg <- mkindsg$new("Experimental X", experimental_data_for_UBA_2019[6:10])
print(mdsg)
print(mdsg, verbose = TRUE)
print(mdsg, verbose = TRUE, data = TRUE)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{title}}{A title for the dataset group}

\item{\code{ds}}{A list of mkinds objects}

\item{\code{observed_n}}{Occurrence counts of compounds in datasets}

\item{\code{f_time_norm}}{Time normalisation factors}

\item{\code{meta}}{A data frame with a row for each dataset,
containing additional information in the form
of categorical data (factors) or numerical data
(e.g. temperature, moisture,
or covariates like soil pH).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{mkindsg$new()}}
\item \href{#method-clone}{\code{mkindsg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new mkindsg object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mkindsg$new(title = "", ds, f_time_norm = rep(1, length(ds)), meta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{The title}

\item{\code{ds}}{A list of mkinds objects}

\item{\code{f_time_norm}}{Time normalisation factors}

\item{\code{meta}}{The meta data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mkindsg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
