% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_mlb.R
\name{theme_mlb}
\alias{theme_x_mlb}
\alias{theme_y_mlb}
\title{Theme for MLB Team Logos}
\usage{
theme_x_mlb()

theme_y_mlb()
}
\value{
A ggplot2 theme created with \code{\link[ggplot2:theme]{ggplot2::theme()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
\code{theme_x_mlb()} and \code{theme_y_mlb()} have been superceded in favor of \verb{element_*_logo()} functions
These functions are convenience wrappers around a theme call
that activates markdown in x-axis and y-axis labels
using \code{\link[ggtext:element_markdown]{ggtext::element_markdown()}}.
}
\details{
These functions are a wrapper around the function calls
\code{ggplot2::theme(axis.text.x = ggtext::element_markdown())} as well as
\code{ggplot2::theme(axis.text.y = ggtext::element_markdown())}.
They are made to be used in conjunction with \code{\link[=scale_x_mlb]{scale_x_mlb()}} and
\code{\link[=scale_y_mlb]{scale_y_mlb()}} respectively.
}
\examples{
\donttest{
library(mlbplotR)
library(ggplot2)

team_abbr <- valid_team_names()
# remove conference logos from this example
team_abbr <- team_abbr[!team_abbr \%in\% c("AL", "NL", "MLB")]

df <- data.frame(
  random_value = runif(length(team_abbr), 0, 1),
  teams = team_abbr
)
if (utils::packageVersion("gridtext") > "0.1.4"){
  ggplot(df, aes(x = teams, y = random_value)) +
    geom_col(aes(color = teams, fill = teams), width = 0.5) +
    scale_color_mlb(type = "secondary") +
    scale_fill_mlb(alpha = 0.4) +
    scale_x_mlb() +
    theme_minimal() +
    # theme_*_mlb requires gridtext version > 0.1.4
    theme_x_mlb()
}
}
}
\seealso{
\code{\link[=theme_x_mlb]{theme_x_mlb()}}, \code{\link[=theme_y_mlb]{theme_y_mlb()}}
}
