% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSST.R
\docType{data}
\name{LSST}
\alias{LSST}
\title{LSST}
\format{
A \code{list} with two elements, which are:
\describe{
\item{\code{data}}{A list with 4925 MTS.}
\item{\code{classes}}{A numeric vector indicating the corresponding classes associated with the elements in \code{data}.}
}
}
\usage{
data(LSST)
}
\description{
Multivariate time series (MTS) of simulated light curves imitating astronomical time series from the Large Synoptic Survey
Telescope (LSST). The simulated series are measurements of an object's brightness as a function of time
}
\details{
Each element in \code{data} is a matrix formed by 36 rows (time points) indicating time recordings and 6 columns
(variables) indicating different astronomical filters. The first 2459 elements correspond to the training set, whereas the last 2466 elements
correspond to the test set. The numeric vector \code{classes} is formed by integers from 1 to 14, indicating that there are 14
different classes in the database. Each class is associated with a different astronomical object.
For more information, see \insertCite{bagnall2018uea;textual}{mlmts}.
Run "install.packages("ueadata1", repos="https://anloor7.github.io/drat")"
to access this dataset and use the syntax "ueadata1::LSST".
}
\references{
{

  \insertRef{bagnall2018uea}{mlmts}

  \insertRef{ruiz2021great}{mlmts}

  \insertRef{bagnallweb}{mlmts}

}
}
\keyword{datasets}
