% Generated by roxygen2 (4.0.1): do not edit by hand
\name{RLearner}
\alias{RLearner}
\alias{RLearnerClassif}
\alias{RLearnerRegr}
\alias{RLearnerSurv}
\alias{makeRLearner}
\alias{makeRLearnerClassif}
\alias{makeRLearnerRegr}
\alias{makeRLearnerSurv}
\title{Internal construction / wrapping of learner object.}
\usage{
makeRLearner()

makeRLearnerClassif(cl, package, par.set, par.vals = list(),
  properties = character(0L))

makeRLearnerRegr(cl, package, par.set, par.vals = list(),
  properties = character(0L))

makeRLearnerSurv(cl, package, par.set, par.vals = list(),
  properties = character(0L))
}
\arguments{
\item{cl}{[\code{character(1)}] \cr
Class name for learner to create.
By convention, all classification learners start with \dQuote{classif.},
all regression learners with \dQuote{regr.} and all survival learners
start with \dQuote{surv.}.}

\item{package}{[\code{character}]\cr
Package(s) to load for the implementation of the learner.}

\item{properties}{[\code{character(1)}]\cr
Set of learner properties. Some standard property names include:
\describe{
  \item{numerics}{Can numeric features be handled?}
  \item{factors}{Can factor features be handled?}
  \item{missings}{Can missing features be handled?}
  \item{oneclas,twoclass,multiclass}{Can one-class, two-class or multi-class classification problems be handled?}
  \item{prob}{Can probabilites be predicted?}
  \item{se}{Can standard errors be predicted?}
}
Default is \code{character(0)}.}

\item{par.set}{[\code{\link[ParamHelpers]{ParamSet}}] \cr
Parameter set of (hyper)parameters and their constraints.}

\item{par.vals}{[\code{list}] \cr
Always set hyperparameters to these values when the object is constructed.
Useful when default values are missing in the underlying function.
The values can later be overwritten when the user sets hyperparameters.
Default is empty list.}
}
\value{
[\code{\link{RLearnerClassif}}, \code{\link{RLearnerRegr}} or \code{\link{RLearnerSurv}}].
}
\description{
Wraps an already implemented learning method from R to make it accessible to mlr.
Call this method in your constructor. You have to pass an id (name), the required
package(s), a description object for all changeable parameters (you dont have to do this for the
learner to work, but it is strongly recommended), and use property tags to define features of the learner.
}

