% Generated by roxygen2 (4.0.1): do not edit by hand
\name{benchmark}
\alias{benchmark}
\title{Benchmark experiment for multiple learners and tasks.}
\usage{
benchmark(learners, tasks, resamplings, measures,
  show.info = getMlrOption("show.info"))
}
\arguments{
\item{learners}{[(list of) \code{\link{Learner}}]\cr
Learning algorithms which should be compared.}

\item{tasks}{[(list of) \code{\link{SupervisedTask}}]\cr
Tasks that learners should be run on.}

\item{resamplings}{[(list of) \code{\link{ResampleDesc}} | \code{\link{ResampleInstance}}]\cr
Resampling strategy for each tasks.
If only one is provided, it will be replicated to match the number of tasks.
If missing, a 10-fold cross validation is used.}

\item{measures}{[(list of) \code{\link{Measure}}]\cr
Performance measures for all tasks.
If missing, the default measure of the first task is used.}

\item{show.info}{[\code{logical(1)}]\cr
Print verbose output on console?
Default is set via \code{\link{configureMlr}}.}
}
\value{
[\code{BenchmarkResult}].
}
\description{
Complete benchmark experiment to compare different learning algorithms across one or more tasks
w.r.t. a given resampling strategy. Experiments are paired, meaning always the same
training / test sets are used for the different learners.
Furhtermore, your learners can be automatically tuned using \code{\link{makeTuneWrapper}}.
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}};
  \code{\link{FilterResult}},
  \code{\link{getFilterResult}};
  \code{\link{getAggrPerformances}};
  \code{\link{getFeatSelResult}};
  \code{\link{getPerformances}};
  \code{\link{getPredictions}}; \code{\link{getTuneResult}}
}

