% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractFDAFeatures.R
\name{extractFDAFeatures}
\alias{extractFDAFeatures}
\title{Extract features from functional data.}
\usage{
extractFDAFeatures(obj, target = character(0L), feat.methods = list())
}
\arguments{
\item{obj}{(\link{Task} | \link{data.frame})\cr
Task or data.frame to extract functional features from.
Must contain functional features as matrix columns.}

\item{target}{(\link{character})\cr
Task target column. Only neccessary for data.frames
Default is \code{character(0)}.}

\item{feat.methods}{(named \link{list})\cr
List of functional features along with the desired methods for each functional feature.
\dQuote{all} applies the \link{extractFDAFeatures} method to each
functional feature.
Names of \code{feat.methods} must match column names of functional features.
Available feature extraction methods are available under family \code{fda_featextractor}.
Default is \link{list} which does nothing.}
}
\value{
(\link{list})
\item{data (\link{data.frame} | \link{Task})}{Extracted features, returns a data.frame when
given a \link{data.frame} and a Task when given a Task.}
\item{desc (\code{extractFDAFeatDesc})}{Description object. See description for details.}
}
\description{
Extract non-functional features from functional features using various methods.
The function \link{extractFDAFeatures} performs the extraction for all functional features
via the methods specified in \code{feat.methods} and transforms all mentioned functional
matrix features into regular data.frame columns.
Additionally, a \dQuote{\code{extractFDAFeatDesc}} object
which contains learned coefficients and other helpful data for
extraction during the predict-phase is returned. This can be used with
\link{reextractFDAFeatures} in order to extract features during the prediction phase.
}
\details{
The description object contains these slots
\describe{
\item{target \link{character}}{See argument.}
\item{coln \link{character}}{colum names of data.}
\item{fd.cols \link{character}}{Functional feature names.}
\item{extractFDAFeat \link{list}}{Contains \code{feature.methods} and relevant
parameters for reextraction}.
}
}
\seealso{
Other fda: \code{\link{makeExtractFDAFeatMethod}},
  \code{\link{makeExtractFDAFeatsWrapper}}
}
