% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CostSensClassifWrapper.R
\name{makeCostSensClassifWrapper}
\alias{CostSensClassifModel}
\alias{CostSensClassifWrapper}
\alias{makeCostSensClassifWrapper}
\title{Wraps a classification learner for use in cost-sensitive learning.}
\usage{
makeCostSensClassifWrapper(learner)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The classification learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Creates a wrapper, which can be used like any other learner object.
The classification model can easily be accessed via \code{\link{getHomogeneousEnsembleModels}}.

This is a very naive learner, where the costs are transformed into classification labels -
the label for each case is the name of class with minimal costs.
(If ties occur, the label which is better on average w.r.t. costs over all training data is
preferred.)
Then the classifier is fitted to that data and subsequently used for prediction.
}
\seealso{
Other costsens: \code{\link{ClassifTask}},
  \code{\link{ClusterTask}}, \code{\link{CostSensTask}},
  \code{\link{RegrTask}}, \code{\link{SurvTask}},
  \code{\link{Task}}, \code{\link{makeClassifTask}},
  \code{\link{makeClusterTask}},
  \code{\link{makeCostSensTask}},
  \code{\link{makeRegrTask}}, \code{\link{makeSurvTask}};
  \code{\link{CostSensRegrModel}},
  \code{\link{CostSensRegrWrapper}},
  \code{\link{makeCostSensRegrWrapper}};
  \code{\link{CostSensWeightedPairsModel}},
  \code{\link{CostSensWeightedPairsWrapper}},
  \code{\link{makeCostSensWeightedPairsWrapper}}

Other wrapper: \code{\link{CostSensRegrModel}},
  \code{\link{CostSensRegrWrapper}},
  \code{\link{makeCostSensRegrWrapper}};
  \code{\link{makeBaggingWrapper}};
  \code{\link{makeDownsampleWrapper}};
  \code{\link{makeFeatSelWrapper}};
  \code{\link{makeFilterWrapper}};
  \code{\link{makeImputeWrapper}};
  \code{\link{makeMulticlassWrapper}};
  \code{\link{makeOverBaggingWrapper}};
  \code{\link{makeOversampleWrapper}},
  \code{\link{makeUndersampleWrapper}};
  \code{\link{makePreprocWrapperCaret}};
  \code{\link{makePreprocWrapper}};
  \code{\link{makeSMOTEWrapper}};
  \code{\link{makeTuneWrapper}};
  \code{\link{makeWeightedClassesWrapper}}
}

