% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateThreshVsPerf.R
\name{generateThreshVsPerfData}
\alias{generateThreshVsPerfData}
\title{Generate threshold vs. performance(s) for 2-class classification.}
\usage{
generateThreshVsPerfData(obj, measures, gridsize = 100L, aggregate = TRUE,
  task.id = NULL)
}
\arguments{
\item{obj}{[(list of) \code{\link{Prediction}} | (list of) \code{\link{ResampleResult}} | \code{\link{BenchmarkResult}}]\cr
Single prediction object, list of them, single resample result, list of them, or a benchmark result.
In case of a list probably produced by different learners you want to compare, then
name the list with the names you want to see in the plots, probably
learner shortnames or ids.}

\item{measures}{[\code{\link{Measure}} | list of \code{\link{Measure}}]\cr
Performance measure(s) to evaluate.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{gridsize}{[\code{integer(1)}]\cr
Grid resolution for x-axis (threshold).
Default is 100.}

\item{aggregate}{[\code{logical(1)}]\cr
Whether to aggregate \code{\link{ResamplePrediction}}s or to plot the performance
of each iteration separately.
Default is \code{TRUE}.}

\item{task.id}{[\code{character(1)}]\cr
Selected task in \code{\link{BenchmarkResult}} to do plots for, ignored otherwise.
Default is first task.}
}
\value{
[\code{ThreshVsPerfData}]. A named list containing the measured performance
  across the threshold grid, the measures, and whether the performance estimates were
  aggregated (only applicable for (list of) \code{\link{ResampleResult}}s).
}
\description{
Generates data on threshold vs. performance(s) for 2-class classification that can be used for plotting.
}
\seealso{
Other generate_plot_data: \code{\link{generateCalibrationData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateFilterValuesData}},
  \code{\link{generateLearningCurveData}},
  \code{\link{generatePartialPredictionData}},
  \code{\link{generateROCRCurvesData}},
  \code{\link{getFilterValues}}

Other thresh_vs_perf: \code{\link{plotROCCurves}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

