% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateThreshVsPerf.R
\name{plotThreshVsPerfGGVIS}
\alias{plotThreshVsPerfGGVIS}
\title{Plot threshold vs. performance(s) for 2-class classification using ggvis.}
\usage{
plotThreshVsPerfGGVIS(obj, interaction = "measure", mark.th = NA_real_,
  pretty.names = TRUE)
}
\arguments{
\item{obj}{[\code{ThreshVsPerfData}]\cr
Result of \code{\link{generateThreshVsPerfData}}.}

\item{interaction}{[\code{character(1)}]\cr
Selects \dQuote{measure} or \dQuote{learner} to be used in a Shiny application
making the \code{interaction} variable selectable via a drop-down menu.
This variable must have more than one unique value, otherwise it will be ignored.
The variable not chosen is mapped to color if it has more than one unique value.
Note that if there are multiple learners and multiple measures interactivity is
necessary as ggvis does not currently support facetting or subplots.
The default is \dQuote{measure}.}

\item{mark.th}{[\code{numeric(1)}]\cr
Mark given threshold with vertical line?
Default is \code{NA} which means not to do it.}

\item{pretty.names}{[\code{logical(1)}]\cr
Whether to use the \code{\link{Measure}} name instead of the id in the plot.
Default is \code{TRUE}.}
}
\value{
a ggvis plot object.
}
\description{
Plots threshold vs. performance(s) data that has been generated with \code{\link{generateThreshVsPerfData}}.
}
\examples{
\dontrun{
lrn = makeLearner("classif.rpart", predict.type = "prob")
mod = train(lrn, sonar.task)
pred = predict(mod, sonar.task)
pvs = generateThreshVsPerfData(pred, list(tpr, fpr))
plotThreshVsPerfGGVIS(pvs)
}
}
\seealso{
Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCCurves}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotROCRCurves}},
  \code{\link{plotThreshVsPerf}}

Other thresh_vs_perf: \code{\link{generateThreshVsPerfData}},
  \code{\link{plotROCCurves}},
  \code{\link{plotThreshVsPerf}}
}

