% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegr.R
\docType{data}
\name{LearnerRegr}
\alias{LearnerRegr}
\title{Regression Learner}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Learner}.}
\description{
This Learner specializes \link{Learner} for regression problems.

Many predefined learners can be found in the \link{Dictionary} \link{mlr_learners} after loading the \CRANpkg{mlr3learners} package.
}
\section{Construction}{
\preformatted{l = LearnerRegr$new(id, param_set = ParamSet$new(), param_vals = list(), predict_types = character(),
     feature_types = character(), properties = character(), data_formats = "data.table", packages = character())
}

For a description of the arguments, see \link{Learner}.
\code{task_type} is set to \code{"regr"}.
Possible values for \code{predict_types} are a subset of \code{c("response", "se")}.
}

\section{Fields}{

See \link{Learner}.
}

\section{Methods}{

See \link{Learner}.
}

\examples{
# get all regression learners from mlr_learners:
lrns = mlr_learners$mget(mlr_learners$keys("^regr"))
names(lrns)

# get a specific learner from mlr_learners:
mlr_learners$get("regr.rpart")
lrn("classif.featureless")
}
\seealso{
Example regression learners: \code{\link[=mlr_learners_regr.rpart]{regr.rpart}}

Other Learner: \code{\link{LearnerClassif}},
  \code{\link{Learner}}, \code{\link{mlr_learners}}
}
\concept{Learner}
\keyword{datasets}
