% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{mlr_assertions}
\alias{mlr_assertions}
\alias{assert_backend}
\alias{assert_task}
\alias{assert_tasks}
\alias{assert_learner}
\alias{assert_learners}
\alias{assert_learnable}
\alias{assert_measure}
\alias{assert_measures}
\alias{assert_resampling}
\alias{assert_resamplings}
\alias{assert_prediction}
\alias{assert_resample_result}
\alias{assert_benchmark_result}
\alias{assert_row_ids}
\title{Assertion for mlr3 Objects}
\usage{
assert_backend(b, .var.name = vname(b))

assert_task(
  task,
  task_type = NULL,
  feature_types = NULL,
  task_properties = NULL,
  .var.name = vname(task)
)

assert_tasks(
  tasks,
  task_type = NULL,
  feature_types = NULL,
  task_properties = NULL,
  .var.name = vname(tasks)
)

assert_learner(
  learner,
  task = NULL,
  properties = character(),
  .var.name = vname(learner)
)

assert_learners(
  learners,
  task = NULL,
  properties = character(),
  .var.name = vname(learners)
)

assert_learnable(task, learner)

assert_measure(
  measure,
  task = NULL,
  learner = NULL,
  .var.name = vname(measure)
)

assert_measures(
  measures,
  task = NULL,
  learner = NULL,
  .var.name = vname(measures)
)

assert_resampling(
  resampling,
  instantiated = NULL,
  .var.name = vname(resampling)
)

assert_resamplings(
  resamplings,
  instantiated = NULL,
  .var.name = vname(resamplings)
)

assert_prediction(prediction, .var.name = vname(prediction))

assert_resample_result(rr, .var.name = vname(rr))

assert_benchmark_result(bmr, .var.name = vname(bmr))

assert_row_ids(row_ids, null.ok = FALSE, .var.name = vname(row_ids))
}
\arguments{
\item{b}{(\link{DataBackend}).}

\item{task}{(\link{Task}).}

\item{feature_types}{(\code{character()})\cr
Feature types the learner operates on. Must be a subset of \code{\link[=mlr_reflections]{mlr_reflections$task_feature_types}}.}

\item{task_properties}{(\code{character()})\cr
Set of required task properties.}

\item{tasks}{(list of \link{Task}).}

\item{learner}{(\link{Learner}).}

\item{learners}{(list of \link{Learner}).}

\item{measure}{(\link{Measure}).}

\item{measures}{(list of \link{Measure}).}

\item{resampling}{(\link{Resampling}).}

\item{resamplings}{(list of \link{Resampling}).}

\item{prediction}{(\link{Prediction}).}

\item{bmr}{(\link{BenchmarkResult}).}

\item{row_ids}{(\code{numeric()}).}

\item{resample_result}{(\link{ResampleResult}).}
}
\description{
Functions intended to be used in packages extending \pkg{mlr3}.
Most assertion functions ensure the right class attrbiture, and optionally additional properties.
Additionally, the following compound assertions are implemented:
\itemize{
\item \code{assert_learnable(task, learner)}\cr
(\link{Task}, \link{Learner}) -> \code{NULL}\cr
Checks if the learner is applicable to the task.
This includes type checks on the type, the feature types, and properties.
}

If an assertion fails, an exception is raised.
Otherwise, the input object is returned invisibly.
}
\keyword{internal}
