% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClustMiniBatchKMeans.R
\name{mlr_learners_clust.MBatchKMeans}
\alias{mlr_learners_clust.MBatchKMeans}
\alias{LearnerClustMiniBatchKMeans}
\title{Mini Batch K-Means Clustering Learner}
\description{
A \link{LearnerClust} for mini batch k-means clustering implemented in \code{\link[ClusterR:MiniBatchKmeans]{ClusterR::MiniBatchKmeans()}}.
\code{\link[ClusterR:MiniBatchKmeans]{ClusterR::MiniBatchKmeans()}} doesn't have a default value for the number of clusters.
Therefore, the \code{clusters} parameter here is set to 2 by default.
The predict method uses \code{\link[ClusterR:predict_MBatchKMeans]{ClusterR::predict_MBatchKMeans()}} to compute the
cluster memberships for new data.
The learner supports both partitional and fuzzy clustering.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("clust.MBatchKMeans")
lrn("clust.MBatchKMeans")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{clust}
\item Predict Types: \dQuote{partition}, \dQuote{prob}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3cluster}, \CRANpkg{ClusterR}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   clusters \tab integer \tab 2 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   batch_size \tab integer \tab 10 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   num_init \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   max_iters \tab integer \tab 100 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   init_fraction \tab numeric \tab 1 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   initializer \tab character \tab kmeans++ \tab optimal_init, quantile_init, kmeans++, random \tab - \cr
   early_stop_iter \tab integer \tab 10 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   verbose \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   CENTROIDS \tab untyped \tab  \tab  \tab - \cr
   tol \tab numeric \tab 1e-04 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   tol_optimal_init \tab numeric \tab 0.3 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   seed \tab integer \tab 1 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
}
}

\examples{
if (requireNamespace("ClusterR")) {
  learner = mlr3::lrn("clust.MBatchKMeans")
  print(learner)

  # available parameters:
  learner$param_set$ids()
}
}
\references{
Sculley, David (2010).
\dQuote{Web-scale k-means clustering.}
In \emph{Proceedings of the 19th international conference on World wide web}, 1177--1178.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html#sec-learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_clust.SimpleKMeans}},
\code{\link{mlr_learners_clust.agnes}},
\code{\link{mlr_learners_clust.ap}},
\code{\link{mlr_learners_clust.cmeans}},
\code{\link{mlr_learners_clust.cobweb}},
\code{\link{mlr_learners_clust.dbscan}},
\code{\link{mlr_learners_clust.dbscan_fpc}},
\code{\link{mlr_learners_clust.diana}},
\code{\link{mlr_learners_clust.em}},
\code{\link{mlr_learners_clust.fanny}},
\code{\link{mlr_learners_clust.featureless}},
\code{\link{mlr_learners_clust.ff}},
\code{\link{mlr_learners_clust.hclust}},
\code{\link{mlr_learners_clust.hdbscan}},
\code{\link{mlr_learners_clust.kkmeans}},
\code{\link{mlr_learners_clust.kmeans}},
\code{\link{mlr_learners_clust.mclust}},
\code{\link{mlr_learners_clust.meanshift}},
\code{\link{mlr_learners_clust.optics}},
\code{\link{mlr_learners_clust.pam}},
\code{\link{mlr_learners_clust.xmeans}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3cluster:LearnerClust]{mlr3cluster::LearnerClust}} -> \code{LearnerClustMiniBatchKMeans}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClustMiniBatchKMeans-new}{\code{LearnerClustMiniBatchKMeans$new()}}
\item \href{#method-LearnerClustMiniBatchKMeans-clone}{\code{LearnerClustMiniBatchKMeans$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3cluster" data-topic="LearnerClust" data-id="reset"><a href='../../mlr3cluster/html/LearnerClust.html#method-LearnerClust-reset'><code>mlr3cluster::LearnerClust$reset()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustMiniBatchKMeans-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustMiniBatchKMeans-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustMiniBatchKMeans$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustMiniBatchKMeans-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustMiniBatchKMeans-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustMiniBatchKMeans$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
