% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterPermutation.R
\name{mlr_filters_permutation}
\alias{mlr_filters_permutation}
\alias{FilterPermutation}
\title{Permutation Score Filter}
\description{
The permutation filter randomly permutes the values of a single feature in a
\link[mlr3:Task]{mlr3::Task} to break the association with the response. The permuted
feature, together with the unmodified features, is used to perform a
\code{\link[mlr3:resample]{mlr3::resample()}}. The permutation filter score is the difference between
the aggregated performance of the \link[mlr3:Measure]{mlr3::Measure} and the performance
estimated on the unmodified \link[mlr3:Task]{mlr3::Task}.
}
\section{Parameters}{

\describe{
\item{\code{standardize}}{\code{logical(1)}\cr
Standardize feature importance by maximum score.}
\item{\code{nmc}}{\code{integer(1)}}\cr
Number of Monte-Carlo iterations to use in computing the feature importance.
}
}

\examples{
if (requireNamespace("rpart")) {
  learner = mlr3::lrn("classif.rpart")
  resampling = mlr3::rsmp("holdout")
  measure = mlr3::msr("classif.acc")
  filter = flt("permutation", learner = learner, measure = measure, resampling = resampling,
    nmc = 2)
  task = mlr3::tsk("iris")
  filter$calculate(task)
  as.data.table(filter)
}

if (mlr3misc::require_namespaces(c("mlr3pipelines", "rpart"), quietly = TRUE)) {
  library("mlr3pipelines")
  task = mlr3::tsk("iris")

  # Note: `filter.frac` is selected randomly and should be tuned.

  graph = po("filter", filter = flt("permutation", nmc = 2), filter.frac = 0.5) \%>>\%
    po("learner", mlr3::lrn("classif.rpart"))

  graph$train(task)
}
}
\seealso{
\itemize{
\item \link[mlr3pipelines:mlr_pipeops_filter]{PipeOpFilter} for filter-based feature selection.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}
}

Other Filter: 
\code{\link{Filter}},
\code{\link{mlr_filters_anova}},
\code{\link{mlr_filters_auc}},
\code{\link{mlr_filters_carscore}},
\code{\link{mlr_filters_carsurvscore}},
\code{\link{mlr_filters_cmim}},
\code{\link{mlr_filters_correlation}},
\code{\link{mlr_filters_disr}},
\code{\link{mlr_filters_find_correlation}},
\code{\link{mlr_filters_importance}},
\code{\link{mlr_filters_information_gain}},
\code{\link{mlr_filters_jmim}},
\code{\link{mlr_filters_jmi}},
\code{\link{mlr_filters_kruskal_test}},
\code{\link{mlr_filters_mim}},
\code{\link{mlr_filters_mrmr}},
\code{\link{mlr_filters_njmim}},
\code{\link{mlr_filters_performance}},
\code{\link{mlr_filters_relief}},
\code{\link{mlr_filters_selected_features}},
\code{\link{mlr_filters_variance}},
\code{\link{mlr_filters}}
}
\concept{Filter}
\section{Super class}{
\code{\link[mlr3filters:Filter]{mlr3filters::Filter}} -> \code{FilterPermutation}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr}

\item{\code{measure}}{(\link[mlr3:Measure]{mlr3::Measure})\cr}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FilterPermutation-new}{\code{FilterPermutation$new()}}
\item \href{#method-FilterPermutation-clone}{\code{FilterPermutation$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="calculate"><a href='../../mlr3filters/html/Filter.html#method-Filter-calculate'><code>mlr3filters::Filter$calculate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="format"><a href='../../mlr3filters/html/Filter.html#method-Filter-format'><code>mlr3filters::Filter$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="help"><a href='../../mlr3filters/html/Filter.html#method-Filter-help'><code>mlr3filters::Filter$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="print"><a href='../../mlr3filters/html/Filter.html#method-Filter-print'><code>mlr3filters::Filter$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterPermutation-new"></a>}}
\if{latex}{\out{\hypertarget{method-FilterPermutation-new}{}}}
\subsection{Method \code{new()}}{
Create a FilterPermutation object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterPermutation$new(
  learner = mlr3::lrn("classif.featureless"),
  resampling = mlr3::rsmp("holdout"),
  measure = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
\link[mlr3:Learner]{mlr3::Learner} to use for model fitting.}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
\link[mlr3:Resampling]{mlr3::Resampling} to be used within resampling.}

\item{\code{measure}}{(\link[mlr3:Measure]{mlr3::Measure})\cr
\link[mlr3:Measure]{mlr3::Measure} to be used for evaluating the performance.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterPermutation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FilterPermutation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterPermutation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
