% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterUnivariateCox.R
\name{mlr_filters_univariate_cox}
\alias{mlr_filters_univariate_cox}
\alias{FilterUnivariateCox}
\title{Univariate Cox Survival Filter}
\description{
Calculates scores for assessing the relationship between
individual features and the time-to-event outcome (right-censored survival
data) using a univariate Cox proportional hazards model.
The goal is to determine which features have a statistically significant
association with the event of interest, typically in the context of clinical
or biomedical research.

This filter fits a \link[survival:coxph]{Cox Proportional Hazards} model using
each feature independently and extracts the \eqn{p}-value that quantifies the
significance of the feature's impact on survival. The filter value is
\code{-log10(p)} where \code{p} is the \eqn{p}-value. This transformation is necessary
to ensure numerical stability for very small \eqn{p}-values. Also higher
values denote more important features. The filter works only for numeric
features so please ensure that factor variables are properly encoded, e.g.
using \link[mlr3pipelines:mlr_pipeops_encode]{PipeOpEncode}.
}
\examples{

filter = flt("univariate_cox")
filter

}
\seealso{
\itemize{
\item \link[mlr3pipelines:mlr_pipeops_filter]{PipeOpFilter} for filter-based feature selection.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}
}

Other Filter: 
\code{\link{Filter}},
\code{\link{mlr_filters}},
\code{\link{mlr_filters_anova}},
\code{\link{mlr_filters_auc}},
\code{\link{mlr_filters_boruta}},
\code{\link{mlr_filters_carscore}},
\code{\link{mlr_filters_carsurvscore}},
\code{\link{mlr_filters_cmim}},
\code{\link{mlr_filters_correlation}},
\code{\link{mlr_filters_disr}},
\code{\link{mlr_filters_find_correlation}},
\code{\link{mlr_filters_importance}},
\code{\link{mlr_filters_information_gain}},
\code{\link{mlr_filters_jmi}},
\code{\link{mlr_filters_jmim}},
\code{\link{mlr_filters_kruskal_test}},
\code{\link{mlr_filters_mim}},
\code{\link{mlr_filters_mrmr}},
\code{\link{mlr_filters_njmim}},
\code{\link{mlr_filters_performance}},
\code{\link{mlr_filters_permutation}},
\code{\link{mlr_filters_relief}},
\code{\link{mlr_filters_selected_features}},
\code{\link{mlr_filters_variance}}
}
\concept{Filter}
\section{Super class}{
\code{\link[mlr3filters:Filter]{mlr3filters::Filter}} -> \code{FilterUnivariateCox}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FilterUnivariateCox-new}{\code{FilterUnivariateCox$new()}}
\item \href{#method-FilterUnivariateCox-clone}{\code{FilterUnivariateCox$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="calculate"><a href='../../mlr3filters/html/Filter.html#method-Filter-calculate'><code>mlr3filters::Filter$calculate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="format"><a href='../../mlr3filters/html/Filter.html#method-Filter-format'><code>mlr3filters::Filter$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="help"><a href='../../mlr3filters/html/Filter.html#method-Filter-help'><code>mlr3filters::Filter$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="print"><a href='../../mlr3filters/html/Filter.html#method-Filter-print'><code>mlr3filters::Filter$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterUnivariateCox-new"></a>}}
\if{latex}{\out{\hypertarget{method-FilterUnivariateCox-new}{}}}
\subsection{Method \code{new()}}{
Create a FilterUnivariateCox object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterUnivariateCox$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterUnivariateCox-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FilterUnivariateCox-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterUnivariateCox$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
