% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoFSelect.R
\name{AutoFSelect}
\alias{AutoFSelect}
\title{AutoFSelect}
\description{
The \code{AutoFSelect} is a \link[mlr3:Learner]{mlr3::Learner} which wraps another \link[mlr3:Learner]{mlr3::Learner}
and performs the following steps during \verb{$train()}:
\enumerate{
\item The wrapped (inner) learner is trained on the feature subsets via
resampling. The feature selection can be specified by providing a
\link{FSelector}, a \link[bbotk:Terminator]{bbotk::Terminator}, a \link[mlr3:Resampling]{mlr3::Resampling} and a
\link[mlr3:Measure]{mlr3::Measure}.
\item A final model is fit on the complete training data with the best found
feature subset.
}

During \verb{$predict()} the \code{AutoFSelect} just calls the predict method of the
wrapped (inner) learner.

Note that this approach allows to perform nested resampling by passing an
\link{AutoFSelect} object to \code{\link[mlr3:resample]{mlr3::resample()}} or \code{\link[mlr3:benchmark]{mlr3::benchmark()}}.
To access the inner resampling results, set \code{store_fselect_instance = TRUE}
and execute \code{\link[mlr3:resample]{mlr3::resample()}} or \code{\link[mlr3:benchmark]{mlr3::benchmark()}} with
\code{store_models = TRUE} (see examples).
}
\examples{
library(mlr3)

task = tsk("iris")
learner = lrn("classif.rpart")
resampling = rsmp("holdout")
measure = msr("classif.ce")

terminator = trm("evals", n_evals = 15)
fselector = fs("exhaustive_search")
afs = AutoFSelect$new(learner, resampling, measure, terminator, fselector)
afs$store_fselect_instance = TRUE

afs$train(task)
afs$model
afs$learner

#  Nested resampling
afs = AutoFSelect$new(learner, resampling, measure, terminator, fselector)
afs$store_fselect_instance = TRUE

resampling_outer = rsmp("cv", folds = 2)
rr = resample(task, afs, resampling_outer, store_models = TRUE)

# Aggregate performance of outer results
rr$aggregate()

# Retrieve inner feature selection results.
as.data.table(rr)$learner[[1]]$fselect_result
}
\section{Super class}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{AutoFSelect}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{instance_args}}{(\code{list()})\cr
All arguments from construction to create the
\link{FSelectInstanceSingleCrit}.}

\item{\code{fselector}}{(\link{FSelector})\cr
Stores the feature selection algorithm.}

\item{\code{store_fselect_instance}}{(\code{logical(1)}).
If \code{TRUE} (default), stores the internally created
\link{FSelectInstanceSingleCrit} with all intermediate results in slot
\verb{$fselect_instance}.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{archive}}{(\link[bbotk:Archive]{bbotk::Archive})\cr
Returns \link{FSelectInstanceSingleCrit} archive.}

\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Trained learner.}

\item{\code{fselect_instance}}{(\link{FSelectInstanceSingleCrit})\cr
Internally created feature selection instance with all intermediate
results.}

\item{\code{fselect_result}}{(named \code{list()})\cr
Short-cut to \verb{$result} from \link{FSelectInstanceSingleCrit}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AutoFSelect$new()}}
\item \href{#method-clone}{\code{AutoFSelect$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutoFSelect$new(learner, resampling, measure, terminator, fselector)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to optimize the feature subset for, see
\link{FSelectInstanceSingleCrit}.}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling strategy during feature selection, see
\link{FSelectInstanceSingleCrit}. This \link[mlr3:Resampling]{mlr3::Resampling} is meant to be the
\strong{inner} resampling, operating on the training set of an arbitrary outer
resampling. For this reason it is not feasible to pass an instantiated
\link[mlr3:Resampling]{mlr3::Resampling} here.}

\item{\code{measure}}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Performance measure to optimize.}

\item{\code{terminator}}{(\link[bbotk:Terminator]{bbotk::Terminator})\cr
When to stop feature selection, see \link{FSelectInstanceSingleCrit}.}

\item{\code{fselector}}{(\link{FSelector})\cr
Feature selection algorithm to run.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutoFSelect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
