% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurrogateLearner.R
\name{SurrogateLearner}
\alias{SurrogateLearner}
\title{Surrogate Model Containing a Single Learner}
\description{
Surrogate model containing a single \link[mlr3:LearnerRegr]{mlr3::LearnerRegr}.
}
\section{Parameters}{

\describe{
\item{\code{assert_insample_perf}}{\code{logical(1)}\cr
Should the insample performance of the \link[mlr3:LearnerRegr]{mlr3::LearnerRegr} be asserted after updating the surrogate?
If the assertion fails (i.e., the insample performance based on the \code{perf_measure} does not meet the
\code{perf_threshold}), an error is thrown.
Default is \code{FALSE}.
}
\item{\code{perf_measure}}{\link[mlr3:MeasureRegr]{mlr3::MeasureRegr}\cr
Performance measure which should be use to assert the insample performance of the \link[mlr3:LearnerRegr]{mlr3::LearnerRegr}.
Only relevant if \code{assert_insample_perf = TRUE}.
Default is \link[mlr3:mlr_measures_regr.rsq]{mlr3::mlr_measures_regr.rsq}.
}
\item{\code{perf_threshold}}{\code{numeric(1)}\cr
Threshold the insample performance of the \link[mlr3:LearnerRegr]{mlr3::LearnerRegr} should be asserted against.
Only relevant if \code{assert_insample_perf = TRUE}.
Default is \code{0}.
}
\item{\code{catch_errors}}{\code{logical(1)}\cr
Should errors during updating the surrogate be caught and propagated to the \code{loop_function} which can then handle
the failed acquisition function optimization (as a result of the failed surrogate) appropriately by, e.g., proposing a randomly sampled point for evaluation?
Default is \code{TRUE}.
}
}
}

\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)

  fun = function(xs) {
    list(y = xs$x ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceSingleCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  xdt = generate_design_random(instance$search_space, n = 4)$data

  instance$eval_batch(xdt)

  learner = default_gp()

  surrogate = srlrn(learner, archive = instance$archive)

  surrogate$update()

  surrogate$learner$model
}
}
\section{Super class}{
\code{\link[mlr3mbo:Surrogate]{mlr3mbo::Surrogate}} -> \code{SurrogateLearner}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{print_id}}{(\code{character})\cr
Id used when printing.}

\item{\code{n_learner}}{(\code{integer(1)})\cr
Returns the number of surrogate models.}

\item{\code{assert_insample_perf}}{(\code{numeric()})\cr
Asserts whether the current insample performance meets the performance threshold.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled if at least one of the packages is not installed, but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}

\item{\code{feature_types}}{(\code{character()})\cr
Stores the feature types the surrogate can handle, e.g. \code{"logical"}, \code{"numeric"}, or \code{"factor"}.
A complete list of candidate feature types, grouped by task type, is stored in \code{\link[=mlr_reflections]{mlr_reflections$task_feature_types}}.}

\item{\code{properties}}{(\code{character()})\cr
Stores a set of properties/capabilities the surrogate has.
A complete list of candidate properties, grouped by task type, is stored in \code{\link[=mlr_reflections]{mlr_reflections$learner_properties}}.}

\item{\code{predict_type}}{(\code{character(1)})\cr
Retrieves the currently active predict type, e.g. \code{"response"}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SurrogateLearner-new}{\code{SurrogateLearner$new()}}
\item \href{#method-SurrogateLearner-predict}{\code{SurrogateLearner$predict()}}
\item \href{#method-SurrogateLearner-clone}{\code{SurrogateLearner$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="Surrogate" data-id="format"><a href='../../mlr3mbo/html/Surrogate.html#method-Surrogate-format'><code>mlr3mbo::Surrogate$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="Surrogate" data-id="print"><a href='../../mlr3mbo/html/Surrogate.html#method-Surrogate-print'><code>mlr3mbo::Surrogate$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="Surrogate" data-id="update"><a href='../../mlr3mbo/html/Surrogate.html#method-Surrogate-update'><code>mlr3mbo::Surrogate$update()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SurrogateLearner-new"></a>}}
\if{latex}{\out{\hypertarget{method-SurrogateLearner-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SurrogateLearner$new(learner, archive = NULL, cols_x = NULL, col_y = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}).}

\item{\code{archive}}{(\link[bbotk:Archive]{bbotk::Archive} | \code{NULL})\cr
\link[bbotk:Archive]{bbotk::Archive} of the \link[bbotk:OptimInstance]{bbotk::OptimInstance}.}

\item{\code{cols_x}}{(\code{character()} | \code{NULL})\cr
Column id's of variables that should be used as features.
By default, automatically inferred based on the archive.}

\item{\code{col_y}}{(\code{character(1)} | \code{NULL})\cr
Column id of variable that should be used as a target.
By default, automatically inferred based on the archive.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SurrogateLearner-predict"></a>}}
\if{latex}{\out{\hypertarget{method-SurrogateLearner-predict}{}}}
\subsection{Method \code{predict()}}{
Predict mean response and standard error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SurrogateLearner$predict(xdt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
New data. One row per observation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the columns \code{mean} and \code{se}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SurrogateLearner-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SurrogateLearner-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SurrogateLearner$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
