% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_acqfunctions.R
\docType{data}
\name{mlr_acqfunctions}
\alias{mlr_acqfunctions}
\title{Dictionary of Acquisition Functions}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}
\description{
A simple \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} storing objects of class \link{AcqFunction}.
Each acquisition function has an associated help page, see \code{mlr_acqfunctions_[id]}.

For a more convenient way to retrieve and construct an acquisition function, see \code{\link[=acqf]{acqf()}}.
}
\section{Methods}{

See \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}

\examples{
library(data.table)
as.data.table(mlr_acqfunctions)
acqf("ei")
}
\seealso{
Sugar function: \code{\link[=acqf]{acqf()}}

Other Dictionary: 
\code{\link{mlr_loop_functions}},
\code{\link{mlr_result_assigners}}

Other Acquisition Function: 
\code{\link{AcqFunction}},
\code{\link{mlr_acqfunctions_aei}},
\code{\link{mlr_acqfunctions_cb}},
\code{\link{mlr_acqfunctions_ehvi}},
\code{\link{mlr_acqfunctions_ehvigh}},
\code{\link{mlr_acqfunctions_ei}},
\code{\link{mlr_acqfunctions_eips}},
\code{\link{mlr_acqfunctions_mean}},
\code{\link{mlr_acqfunctions_pi}},
\code{\link{mlr_acqfunctions_sd}},
\code{\link{mlr_acqfunctions_smsego}}
}
\concept{Acquisition Function}
\concept{Dictionary}
\keyword{datasets}
